#include "clock.h"

time_t current_time = 0;

UDPSocket clock_sock;

Endpoint clock_server;

Timer server_clock_timer;

int 
request_clock_to_server ( void )
{
    char clock_msg [ TIME_MSG_SIZE ];
    
    for ( register uint8_t i = 0; i < TIME_MSG_SIZE; i++ ) clock_msg [ i ] = 0x00;
     
    clock_msg [ 0 ] = 0x23;
    
    int send = clock_sock.sendTo ( clock_server, clock_msg, TIME_MSG_SIZE );
    
    if ( debug_clock ) vz_debug ("::%d::%s::%s::%d::", send, clock_msg, clock_server.get_address (), clock_server.get_port () );
    
    if ( send not_eq TIME_MSG_SIZE )
    {
        if ( debug_reconnect ) vz_debug ("Reconnect clock request" );
        int clock_sock_reconnect_ret = clock_sock_reconnect ();
        
        if ( debug_reconnect ) vz_debug ("Valor de retorno no reconnect :: %d", clock_sock_reconnect_ret );
        
        miss_clock_send_pkg  ++;
    }
    
    if ( debug_clock ) vz_debug ("send :: %d", send );
    
    return ( send );
}

int check_clock ( void )
{
    if( server_clock_timer.read() > EXTERNAL_TIME_REQUEST_WAIT_SECONDS )
    {
        server_clock_timer.reset();
        return request_clock_to_server ();
    }
    else
    {
        // nro arbitrario maior que strlen( request_time )
        return 0x30;
    }
}

int update_clock ( void )
{   

    char time_msg[ TIME_MSG_SIZE ];
    
    Endpoint local_clock_server;
    
    int time_msg_rcv = clock_sock.receiveFrom ( local_clock_server, time_msg, sizeof( time_msg ) );
    
    if( time_msg_rcv == -1 )
    {
        if( debug_reconnect ) vz_printf ("Reconnect clock socket");
        clock_sock_reconnect ();
    } else {
        if ( time_msg [ 0 ] != 0x24 )
        {
            vz_debug ("Error: time_msg [ 0 ] != 0x24");
            return time_msg [ 0 ];
        } else if ( time_msg [ 1 ] == 0x00 ) 
        {
            vz_debug ("Error: time_msg [ 0 ] == 0x00");
            return time_msg [ 1 ];
        } else if ( time_msg [ 1 ] > 0x0f )
        { 
            vz_debug ("Error: time_msg [ 0 ] > 0x0f");
            return time_msg [ 1 ];
        }
    }
    
    time_t local_current_time = 0;
    local_current_time = 0;
    
    local_current_time |= ( ( uint32_t ) time_msg [ 40 ] ) << 24;
    local_current_time |= ( ( uint32_t ) time_msg [ 41 ] ) << 16;
    local_current_time |= ( ( uint32_t ) time_msg [ 42 ] ) << 8;
    local_current_time |= ( ( uint32_t ) time_msg [ 43 ] );
    /*
        Como o valor recebido nos bytes [40 41 42 43] correspondem aos segundos decorridos desde 1/1/1900,
        e como queremos trabalhar com unixtime, convertemos fazendo a subtracao de 70 anos = 2208988800
    */
    local_current_time -= 2208988800;
    
    int diff_time  = ( local_current_time > current_time ) ? local_current_time - current_time : current_time - local_current_time;
    
    if ( diff_time > 2 ) current_time = local_current_time;
    
    if ( debug_clock ) vz_debug ("Clock.rcv ( %d ), diff [ %d ] ", local_current_time, diff_time );
    
    return ( local_current_time - current_time );
}

int init_clock ( void )
{   
    char server_ip [ 16 ];
    
    cm -> get_clock_server_ip ( server_ip );

    int clock_server_set_address_ret = clock_server.set_address ( server_ip, CLOCK_SERVER_PORT );
    
    if ( debug_clock ) vz_debug ("clock_server_set_address_ret :: %d", clock_server_set_address_ret );
    
    int clock_sock_bind_ret = clock_sock.bind ( CLOCK_HEADER_PORT );
    
    clock_sock.set_blocking ( false, 0 );
    
    if ( debug_clock ) vz_debug ("clock_sock_bind_ret ::%d", clock_sock_bind_ret );
    
    server_clock_timer.start ();
    
    request_clock_to_server ();
    
    return ( clock_server_set_address_ret | clock_sock_bind_ret );
}

int 
clock_sock_reconnect ( void )
{
    clock_sock.close ();
    
    int clock_sock_bind_ret = clock_sock.bind ( CLOCK_HEADER_PORT );
    
    clock_sock.set_blocking ( false, 0 );
    
    return ( clock_sock_bind_ret );    
}

int show_clock ( void )
{   
    char buffer[ 512 ];
    struct tm * result_tm;
    if ( sizeof( time_t ) != sizeof( long ) )
    {
        vz_printf ("sizeof( time_t ) : %lu -- sizeof( long int ) : %lu\n", sizeof( time_t ), sizeof( long ) );
    }
                                   
    int filled = snprintf( buffer, 512, "current_time : %lu\tclock() : ", current_time );
    int available_bytes = 512 - filled - 1;
                                                                                                                                        
    if ( current_time != 0 )
    {
        result_tm = localtime( ( const time_t *)&current_time );
        if ( result_tm )
        {
            char formated_time[ 16 ];
            
            /* Correcao "manual" do (GMT -3:00) */
            result_tm->tm_hour -= 3;
            if ( result_tm->tm_hour < 0 ) result_tm->tm_hour = 24 + result_tm->tm_hour;
            
            strftime ( formated_time, sizeof( formated_time ), "%Y%m%d%H%M%S", result_tm );
            
            strncat ( buffer, formated_time, available_bytes );
        }
    }
        else
    {
        strncat ( buffer, "???", available_bytes );
    }
    
    vz_printf ( "%s", buffer );
    
    return ( strlen ( buffer ) );
}