#include "call_manager.h"

Timer invite_pkg_retry_timer;
Timer bye_pkg_retry_timer;

VZ_call * 
find_Call ( Vector * v_call, const int ext )
{
    for ( register int i = 0; i < v_call -> size(); i ++ )
    {
        VZ_call * call = NULL;
        
        call = ( VZ_call * )v_call -> get_element ( i );
        if ( call != NULL )
        {
            if ( call -> get_cb_ext () == ext ) return ( call );
        }
    }
    return( NULL );
}

/* remove calls por timeout */
void call_manager ( Vector * v_call, Vector * v_cb, Timeslice * ts )
{
    //FIXME precisa tratar o caso dos parametros NULL ?
    static uint8_t data[ CB_BUFFER_SIZE ], write_buffer[ CB_BUFFER_SIZE ];
    
    for ( register uint8_t i = 0; i < v_call->size(); i++ )
    {
        bool should_remove = false;
        
        VZ_call * call = ( VZ_call * )v_call->get_element( i );
        
        if ( call == NULL ) continue;
        
        if ( end_call )
        {
            if ( end_call_ext == call -> get_cb_ext () )
            {
                end_call = false;
                end_call_ext = 0;
                should_remove = true;
            }
        }
        
        if ( call->is_timetofinish() || call -> cbx_pkg_is_idle() || should_remove )
        {
            if ( debug_invite && !should_remove )
            {
                if ( call -> cbx_pkg_is_idle () ) { 
                    if( debug_invite ) vz_debug ("[%d] Call timeout: no pkg", call -> get_cb_ext () );
                } else { 
                    if( debug_invite ) vz_debug ("[%d] Call timeout", call->get_cb_ext () ); 
                }
            }
            
            v_call -> remove_element ( i );
            Call_Box * cb = find_CB ( v_cb, call -> get_cb_ext () );
            if ( cb != NULL )
            { 
                data [ TIMESLICE_PLACE ] = 0;
                
                send2callboxes ( build_cb_package ( cb -> get_ext (), cb -> get_port (), CB_BYE, 
                    ( char * )data, cb -> msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                
                ts -> return_timeslice ( cb -> call_end () );
            }
            delete( call );    
        }
    }    
    if ( end_call_ext != 0 )
    {
        if ( debug_invite ) vz_debug ( "Call from %i not foud", end_call_ext );
        end_call = false;
        end_call_ext = 0;
    }
}

void 
invite_handler ( Vector * v_call, Vector * v_cb, Timeslice * ts, Call_Box * inviting_cb )
{
    
    if ( ( v_call != NULL ) and ( v_cb != NULL ) and ( ts != NULL ) )
    {
        uint8_t data [ CB_BUFFER_SIZE ];
        uint8_t write_buffer [ CB_BUFFER_SIZE ];
    
        if ( inviting_cb != NULL )
        {
            if ( inviting_cb -> get_status () == cb_idle )
            {
                inviting_cb -> cb_set_status ( cb_trying );
                if ( debug_invite ) vz_debug ("[%d] Request invite <cb_idle,cb_trying>", inviting_cb->get_ext ()  );
            }
        }
        
        for ( register uint8_t i = 0; i < v_cb->size (); i++ )
        {
            Call_Box * cb = ( Call_Box * ) v_cb->get_element ( i );
            
            if ( cb == NULL ) continue;
            
            if ( ( cb -> get_status () == cb_idle ) or ( cb -> get_status () == cb_on_call ) ) continue;
            
            int ext = cb->get_ext ();
            int port = cb->get_port ();
    
            switch ( cb -> get_status () )
            {            
                case cb_trying : {                
                    uint8_t timeslice = ts -> get_timeslice ();
                    
                    if ( timeslice == 0 )
                    {
                        
                        data [ TIMESLICE_PLACE ] = 0x00;
          
                        // validar troca de mensagens com nros "nao previstos"
                        send2callboxes ( build_cb_package ( ext, port, INVITE, 
                            ( char * )data, ( cb->get_msg_id () | BIT7 ), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                         
                        cb -> call_end ();
                         
                        if ( debug_invite ) vz_debug ( "[%d] Trying without TS <cb_trying,cb_idle>", ext );
                        
                        return;
                    }
                        else
                    {
                        
                        data [ TIMESLICE_PLACE ] = timeslice;
                        
                        cb -> call_init ( timeslice );
                        
                        // validar troca de mensagens com nros "nao previstos"    
                        send2callboxes( build_cb_package( ext, port, INVITE, 
                            ( char * )data, cb->get_msg_id (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                        
                        if ( debug_invite ) vz_debug ("[%d] TS::%d <cb_trying,cb_ringing>", ext, data [ TIMESLICE_PLACE ] );
                    }
                }break;
                case cb_ringing : {
                    VZ_call * call = cb -> invite ();
                    
                    if ( cb -> get_sip_status () == sip_busy ){
                        cb->cb_set_status( cb_busy );
                    } 
                        else if ( call != NULL )
                    {
                        if ( find_Call ( v_call, call -> get_cb_ext () ) == NULL ) v_call -> add ( call );
                        
                        call -> init_cbx_pkg_idle_timer ();
                        
                        if ( cb -> get_sip_status () == sip_on_call )
                        {
                        
                            data [ TIMESLICE_PLACE ] = cb -> get_timeslice ();  
                            
                            // confirmar a msg_id se sempre é bem aceita pelo cbx
                            send2callboxes ( build_cb_package( ext, port, INVITE, ( char * )data, 
                                cb->msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                            
                            cb -> call_confirmed ();    
                    
                            if ( debug_invite ) vz_debug ( "[%d] Ringing call ok <cb_ringing,cb_on_call>", ext );
                        }
                    } else {
                        if ( cb -> get_sip_status () == sip_denied )
                        {
                            cb -> cb_set_status ( cb_denied );
                            if ( debug_invite ) vz_debug ( "[%d] call denied <sip_denied>::<cb_ringing,cb_denied>", ext );
                        } else {
                            if ( cb -> time_to_retry () )
                            {                                
                                if ( cb -> get_sip_status () == sip_waiting_trying )
                                {
                                    if ( debug_invite ) vz_debug ("[%4i %3i] Resend invite to *", ext, cb -> get_invite_try_number ()  );
                                    cb -> retry_send_invite_pkg_to_ast ();    
                                }
                            }    
                        }
                    }
                }break;
                case cb_busy : {
                    data [ TIMESLICE_PLACE ] = 0;
                    
                    send2callboxes ( build_cb_package( ext, port, CB_BYE, 
                        ( char * )data, cb->msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                    
                    for ( register uint8_t i = 0; i < v_call -> size (); i++ )
                    {
                        VZ_call * call = ( VZ_call * ) v_call->get_element ( i );
    
                        if ( call -> get_cb_ext () == cb -> get_ext () )
                        { 
                            v_call -> remove_element ( i );
                            if ( call != NULL ) delete ( call );
                            break;
                        }
                    }
                        
                    ts -> return_timeslice ( cb -> call_end () );
                    
                    if ( debug_invite ) vz_debug ( "[%d] Busy Here <cb_busy,cb_idle>", ext );
                }break;
                
                case cb_denied : {
                    data [ TIMESLICE_PLACE ] = 0;
                    
                    send2callboxes ( build_cb_package( ext, port, CB_BYE, 
                        ( char * )data, cb->msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                        
                    for ( register uint8_t i = 0; i < v_call -> size (); i++ )
                    {
                        VZ_call * call = ( VZ_call * ) v_call->get_element ( i );
                        if ( call -> get_cb_ext () == cb->get_ext () )
                        {
                            v_call -> remove_element( i );
                            if ( call != NULL ) delete ( call );
                            break;
                        }
                    }
                    ts -> return_timeslice ( cb -> call_end () );
    
                    if ( debug_invite ) vz_debug ( "[%d] call denied <cb_denied,cb_idle>", ext );
                }break;
            }
        }
    }
}