#include "call_box_manager.h"

Timer timer_refresh;
Timer timer_aging;
Timer timer_sync_refresh;

Call_Box * find_CB ( Vector * v_cb, const int ext )
{
    if ( v_cb == NULL ) return NULL;
    
    for ( register int i = 0; i < v_cb -> size (); i++ )
    {
        Call_Box * cb = NULL;
        
        cb = ( Call_Box * ) v_cb -> get_element ( i );
        if ( cb not_eq NULL )
        {
            if ( cb -> get_ext () == ext ) return ( cb );
        }
    }
    return ( NULL );
}

int 
refresh ( Vector * v_cb )
{
    if ( v_cb not_eq NULL )
    {    
        if ( v_cb -> size () > 0 )
        {
            static int list_index = 0;
            
            led4 = 0;
            
            if ( list_index >= v_cb -> size () ) list_index = 0;
            
            Call_Box * cb = ( Call_Box * ) v_cb -> get_element ( list_index++ );
            
            if ( ( cb not_eq NULL ) and ( cb -> get_status () == cb_idle ) )
            {
                int local_ext = cb -> get_ext ();
                
                Call_Box * pair = cb -> get_pair_cbx ();
                    
                if ( pair not_eq NULL )
                {
                    if ( pair -> get_status () not_eq cb_idle ) return ( local_ext % 2 == 1 ) ? ( 0x21 ) : ( 0x20 );
                    
                    else if ( ( not ( cm -> get_cbx_detach_mode () ) ) and ( pair -> get_timer () >= cm -> get_acceptable_delay () ) ) return ( local_ext % 2 == 1 ) ? ( 0x41 ) : ( 0x40 );
                }
                
                if ( ( cb -> get_timer () < cm -> get_acceptable_delay () ) and ( cb -> get_overflow_times () == 0 ) )
                {
                    static uint8_t data [ CB_BUFFER_SIZE ], write_buffer [ CB_BUFFER_SIZE ];
                    
                    send2callboxes( build_cb_package( local_ext, cb->get_port(), REGISTRY, 
                        ( char * )data, cb -> msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                        
                    if ( debug_refresh ) vz_printf ("[%d] Refresh", local_ext );
                } else {
                    if ( debug_dont_refresh ) vz_debug ("Nao pedindo registro para o [%d]( %d, %d )", 
                        local_ext, cb -> get_timer (), cb -> get_overflow_times () );    
                }
                return( 0 );
            }else return( -5 );
        }else return( -3 );
    }else return( -1 );
}

void wake_all_up ( Vector * v_cb )
{
 /***
    [ Principio ]
        -- Procurar por CBx que constem sem seus pares registrados na lógica.
        -- Mandar uma mensagem do tipo prompt-ping para este elemento
        
    -- Fluxo --
        - Verificar se possui uma lista ordenada de CBx atualizada
            - Caso nao possua, gerar esta lista.
        - Para cada iteraçao
            - Verifica se o CBx é master ou slave
            - Verifica se o par deste esta registrado
                - Caso contratio
                    - Verifica se o CBx encontrado esta em ligaçao
                        - Caso nao esteja, encaminha mensagem de ping para o CBx ausente da dupla.
 ***/
 
    if ( ( v_cb not_eq NULL ) )
    {
        static int ext_list [ u8_MAX_CB_IN_A_BRANCH + 1 ];
        static uint8_t last_size = 0;
        uint8_t size = v_cb -> size ();
        static int wake_all_up_index = 0;
        
        if ( last_size not_eq size ) {
            for ( register int i = 0; i < size; i++ )
                ext_list [ i ] = ( ( Call_Box * ) v_cb -> get_element ( i ) ) -> get_ext ();
            
            qsort ( ext_list, v_cb -> size (), sizeof ( int ), wake_comp );
        }
        
        if ( size > 0 )
        {   
            Call_Box * cb = find_CB ( v_cb, ext_list [ wake_all_up_index ] );
            
            if ( cb not_eq NULL )
            {
                Call_Box * pair = cb -> get_pair_cbx ();
                
                if ( ( cb -> get_status () == cb_idle ) and ( pair == NULL ) )
                {    
                    uint8_t data [ CB_BUFFER_SIZE ], write_buffer [ CB_BUFFER_SIZE ];
                    
                    strcpy ( ( char * )data, "ping\r" );
                    
                    int cb_ext = cb -> get_ext ();
                    
                    int ext_to_ping = ( ( cb_ext % 2 ) == 0 ) ? cb_ext + 1 : cb_ext - 1;
                    
                    send2callboxes ( build_cb_package ( ext_to_ping, ext_to_ping, PROMPT, ( char * )data, 
                                    cb -> msg_id_update (), CB_BUFFER_SIZE - VZ_HEADER_OFFSET, write_buffer ) );
                            
                    if ( debug_wake ) vz_printf ("%d without %d - ping sent to %d", 
                            cb_ext, ext_to_ping, ext_to_ping );
                }
            }    
        }
        
        if ( ++wake_all_up_index >= size ) wake_all_up_index = 0;
    }
}