#ifndef __BOOTLOADER_H__
#define __BOOTLOADER_H__

#include <stdint.h>
#include "call_box.h"
#include "EthernetInterface.h"

const uint16_t BL_PORT = 3000;
const uint16_t BL_SIZE = 260;
const uint16_t UDP_BL_SIZE = 262;

extern Timer udp_bl_timer;
extern Endpoint udp_bl_server;
extern UDPSocket udp_bl_client;
extern char bl_recv_buffer[ UDP_BL_SIZE ],bl_send_buffer[ UDP_BL_SIZE  ],bl_cbx_buffer[ BL_SIZE + 1 ];
extern uint16_t bl_peer,bl_port;
extern uint8_t bl_start_flag,bl_ts,next_pkg_ts0;
extern Call_Box * bl_cb;
extern uint8_t *bl_write_buffer;

inline int init_bl ( void )
{
  udp_bl_client.bind ( BL_PORT );
  udp_bl_client.set_blocking ( false, 0 );
  return ( 0 );
}

inline int end_bl ( void )
{
  udp_bl_client.close ();
  
  return ( 0 );
}

inline int reconnect_bl ( void )
{
    end_bl ();
    init_bl ();
    
    return ( 0 );
}

#endif