#include "UART3Interrupt.h"

char RXBuffer [ CB_BUFFER_SIZE ];
///< UART3 RX Buffer

volatile uint16_t RX_c = 0;   

///< UART3 Serial Interrupt Handler
void SerialRecvInterrupt( void ){
    while ( LPC_UART3 -> LSR & ( 0<<1 ) ) {}
    // Receive data from UART3 RX
    *( RXBuffer + RX_c ) = LPC_UART3 -> RBR;
    
    RX_c++;
    
    led4 =!led4;
    
    if ( RX_c == 300 ){ 
        status = READ;
        missed_pkg++;
        cpld_pkg_rx_counter++;
    }
}

void RXFrameSync (void) {
    RX_c = 0;
    status = WAITING;
}