#ifndef __CALL_BOX_H__
#define __CALL_BOX_H__

#include "mbed.h"
#include "object.h"
#include "sip.h"
#include "debug.h"
#define __TIMEOUT__  30  /*seconds*/
#define __MAX_ATTEMPTS__  3
#define __STEP__ 30 /*seconds*/
#define __MAX_TIMEOUT__ __STEP__ * __MAX_ATTEMPTS__


#define cb_idle 1
#define cb_ringing 2
#define cb_trying 3
#define cb_on_call 4
#define cb_busy 5

class Call_Box : public Object{
    private :
        int ext;  // ramal
        int port; // porta
        Timer t;
        uint8_t remaining_attempts;
        float timeout;
        uint8_t msg_id;
        uint8_t timeslice;
        
    public :
        Sip * sip;
        Call_Box( int ext, int port );
        ~Call_Box( void );
        
        uint8_t status;
        
        int get_ext( void );
        int get_port( void );
        
        float get_elapsed_time( void );
        bool is_timeout( void );
        uint8_t reconfigure_timeout( void );
        void reset_elapsed_time( void );
        void registry( void );
        VZ_call * invite( void );
        void set_msg_id( uint8_t msg_id );
        uint8_t get_msg_id( void );
        void set_timeslice( uint8_t timeslice );
        uint8_t get_timeslice( void );
        //void set_sip( Sip * sip );
        int listen_SIP_server( void );
        void unregistry( void );
        void send_bye( void );
        void reset_sip( void );
        void set_sip_status( int status );
};

#endif