#ifndef __TEST_H__
#define __TEST_H__

typedef struct{
    uint8_t * buffer_ptr;
    volatile uint8_t * status_ptr;
    int * dest_ext;
    bool * __symbolic_flag__;
}test_control;

void _unit_test_( void const * args );

//#define test_mode_on
#ifdef test_mode_on

void test_registry( void const * args );
void test_aging_registry( void const * args );
void __unit_test_invite__( void const * args );
void test_many_cb_registry( void const * args );
void change_buffer( void const * args );
void unit_test_cb_to_server( void const * args );
void unit_test_cb_from_server( void const * args );

void change_buffer( void const * args ){
    if( args != NULL ){
        uint8_t * buffer = ( uint8_t *)args;
        uint8_t ref = 0x21;
        while( true ){
            for( register int i = 0; i < __CB_BUFFER_SIZE__ - 5 ; i++ ) buffer[ i ] = ref;
            ref++;
        }
    }
}

void unit_test_cb_to_server( void const * args ){
    if( args != NULL ){
        test_control * tc = ( test_control * )args;   
        
        /*  Como vai acontecer esse teste
            o que eu tenho que mudar no buffer
            mandar o invite da primeira chamada, depois mandar o invite da segunda chamada depois ficar trocando dados
        */     
        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x59; // ext 857
        tc->buffer_ptr[ 2 ] = 0x12;
        tc->buffer_ptr[ 3 ] = 0x12; // port 4626
        tc->buffer_ptr[ 4 ] = __INVITE__;
        *( tc->status_ptr ) = (uint8_t)0x01;
        while( *( tc->status_ptr ) == 0x01 ) continue;
        
        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x79; // ext 889
        tc->buffer_ptr[ 2 ] = 0x12;
        tc->buffer_ptr[ 3 ] = 0x13; // port 4627
        tc->buffer_ptr[ 4 ] = __INVITE__;
        *( tc->status_ptr ) = (uint8_t)0x01;
        while( *( tc->status_ptr ) == 0x01 ) continue;
        
        led3 = 1;
        tc->buffer_ptr[ 4 ] = __AUDIO__;
        Timer time_out;
        time_out.start();
        while( time_out.read() < 10 ){
            while( *( tc->status_ptr ) == 0x01 ) continue; //  nao posso escrever se isso nao estiver em 0
            tc->buffer_ptr[ 0 ] = 0x03;
            tc->buffer_ptr[ 1 ] = 0x59; // ext 857
            tc->buffer_ptr[ 2 ] = 0x12;
            tc->buffer_ptr[ 3 ] = 0x12; // port 4626
            *(tc->dest_ext) = 813;
            *(tc->status_ptr) = (uint8_t)0x01;
            
            while( *( tc->status_ptr ) == 0x01 ) continue; //  nao posso escrever se isso nao estiver em 0
            tc->buffer_ptr[ 0 ] = 0x03;
            tc->buffer_ptr[ 1 ] = 0x79; // ext 889
            tc->buffer_ptr[ 2 ] = 0x12;
            tc->buffer_ptr[ 3 ] = 0x13; // port 4627
            *(tc->dest_ext) = 814; // ??? confirmar nro do ramal
            *(tc->status_ptr) = (uint8_t)0x01;
        }
        led3 = 0;
    }   
}

void unit_test_cb_from_server( void const * args ){
    if( args != NULL ){
        test_control * tc = ( test_control * )args;        

        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x59; // ext 857
        tc->buffer_ptr[ 2 ] = 0x12;
        tc->buffer_ptr[ 3 ] = 0x12; // port 4626
        tc->buffer_ptr[ 4 ] = __INVITE__;
        *( tc->status_ptr ) = (uint8_t)0x01;
    
        while( *( tc->status_ptr ) == 0x01 ) continue;
        
        led3 = 1;
        tc->buffer_ptr[ 4 ] = __AUDIO__;
        Timer time_out;
        time_out.start();
        while( time_out.read() < 10 ){
        //  *(tc->status_ptr) = (uint8_t)0x01;
            *(tc->__symbolic_flag__) = false;  
        }
        led3 = 0;
    }   
}

void test_registry( void const * args ){
    if( args != NULL ){
        test_control * tc = ( test_control * )args;
        if( tc == NULL ) return;
        
        uint16_t cc = __checksum__( tc->buffer_ptr + __CHECKSUM_OFFSET__, __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ );

        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x5d; // 861
        tc->buffer_ptr[ 2 ] = 0x10;
        tc->buffer_ptr[ 3 ] = 0x11; // 4113
        tc->buffer_ptr[ 4 ] = ( uint8_t )( ( cc & 0xFF00 ) >> 8 );  
        tc->buffer_ptr[ 5 ] = ( uint8_t )( cc & 0x00FF );
        tc->buffer_ptr[ 6 ] = __REGISTRY__;
        tc->buffer_ptr[ 7 ] = 0x03; // seq
        for( register int i = 8; i < 8 + __CLOCK_SYNC_SIZE__; i++ )// clock
            tc->buffer_ptr[ i ] = 0x00;
        tc->buffer_ptr[ 10 ] = 0x23;

        *(tc->status_ptr) = (uint8_t)__READ__;
    }
}

void __unit_test_invite__( void const * args ){
    if( args != NULL ){
        test_control * tc = ( test_control * )args;        
        
        uint16_t cc = __checksum__( tc->buffer_ptr + __CHECKSUM_OFFSET__, __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ );

        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x5f; // 863
        tc->buffer_ptr[ 2 ] = 0x10;
        tc->buffer_ptr[ 3 ] = 0x11; // 4113
        tc->buffer_ptr[ 4 ] = ( uint8_t )( ( cc & 0xFF00 ) >> 8 );  
        tc->buffer_ptr[ 5 ] = ( uint8_t )( cc & 0x00FF );
        tc->buffer_ptr[ 6 ] = __INVITE__;
        tc->buffer_ptr[ 7 ] = 0x07; // seq
        for( register int i = 8; i < 8 + __CLOCK_SYNC_SIZE__; i++ )
            tc->buffer_ptr[ i ] = i;
        *(tc->status_ptr) = __READ__;
        
           tc->buffer_ptr[ 7 ] = 0x41; // seq
        for( register int i = 8; i < 8 + __CLOCK_SYNC_SIZE__; i++ )
            tc->buffer_ptr[ i ] = 0x41;
        while( *( tc->status_ptr ) == __READ__ ) continue;
        led3 = 1;
        tc->buffer_ptr[ 6 ] = __AUDIO__;
        Timer time_out;
        time_out.start();
        while( time_out.read() < 10 ){
            *(tc->status_ptr) = __READ__;
            *(tc->__symbolic_flag__) = false;
        }
        led3 = 0;
    }   
}

void test_aging_registry( void const * args ){    // single cb, try many
    if( args != NULL ){
        test_control * tc = ( test_control * )args;
        if( tc == NULL ) return;
        
        uint16_t cc = __checksum__( tc->buffer_ptr + __CHECKSUM_OFFSET__, __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ );

        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x5d; // 861
        tc->buffer_ptr[ 2 ] = 0x10;
        tc->buffer_ptr[ 3 ] = 0x11; // 4113
        tc->buffer_ptr[ 4 ] = ( uint8_t )( ( cc & 0xFF00 ) >> 8 );  
        tc->buffer_ptr[ 5 ] = ( uint8_t )( cc & 0x00FF );
        tc->buffer_ptr[ 6 ] = __REGISTRY__;
        tc->buffer_ptr[ 7 ] = 0x03; // seq
        for( register int i = 8; i < 8 + __CLOCK_SYNC_SIZE__; i++ )// clock
            tc->buffer_ptr[ i ] = 0x00;
        tc->buffer_ptr[ 10 ] = 0x23;

        *(tc->status_ptr) = (uint8_t)__READ__;
    }
}


void test_many_cb_registry( void const * args ){
    if( args != NULL ){
        test_control * tc = ( test_control * )args;
        if( tc == NULL ) return;

        tc->buffer_ptr[ 0 ] = 0x03;
        tc->buffer_ptr[ 1 ] = 0x53; // 851
        tc->buffer_ptr[ 2 ] = 0x1b;
        tc->buffer_ptr[ 3 ] = 0xbd; // 7101
        tc->buffer_ptr[ 6 ] = __REGISTRY__;
        tc->buffer_ptr[ 7 ] = 0x03; // seq
        for( register int i = 8; i < 8 + __CLOCK_SYNC_SIZE__; i++ )// clock
            tc->buffer_ptr[ i ] = 0x00;
        tc->buffer_ptr[ 11 ] = 0x23;
        uint16_t cc = __checksum__( tc->buffer_ptr + __CHECKSUM_OFFSET__, __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ );
        tc->buffer_ptr[ 4 ] = ( uint8_t )( ( cc & 0xFF00 ) >> 8 );  
        tc->buffer_ptr[ 5 ] = ( uint8_t )( cc & 0x00FF );
        
        *(tc->status_ptr) = (uint8_t)__READ__;
        while( *(tc->status_ptr) == (uint8_t)__READ__ );
        
        int ext = 851;
        int port = 7101;
        for( register int i = 0; i < 23; i++ ){
            *(tc->status_ptr) = (uint8_t)__READ__;
            tc->buffer_ptr[ 0 ] = ( uint8_t )( ( ext & 0xFF00 ) >> 8 );                                                                                      
            tc->buffer_ptr[ 1 ] = ( uint8_t )( ++ext & 0x00FF ); 
            tc->buffer_ptr[ 2 ] = ( uint8_t )( ( port & 0xFF00 ) >> 8 );                                                                                      
            tc->buffer_ptr[ 3 ] = ( uint8_t )( ++port & 0x00FF );
            uint16_t cc = __checksum__( tc->buffer_ptr + __CHECKSUM_OFFSET__, __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ );
            tc->buffer_ptr[ 4 ] = ( uint8_t )( ( cc & 0xFF00 ) >> 8 );  
            tc->buffer_ptr[ 5 ] = ( uint8_t )( cc & 0x00FF );
            *(tc->status_ptr) = (uint8_t)__READ__;
            while( *(tc->status_ptr) == (uint8_t)__READ__ );
      }
    }    
}

#endif // test_mode_on
#endif // test.h