#include "mbed.h"
#include <stdint.h>
#include "parallelcpld.h"
#include "configs.h"
#include "bits.h"

uint8_t TXBuffer[DATA_SIZE];          // UART3 TX Buffer
uint8_t tx_clear =1;

void parallel_write( uint8_t data)                      // Print a variable using parallel protocol
{   
        data0 = BIT0&(data);
        data1 = BIT1&(data);
        data2 = BIT2&(data);
        data3 = BIT3&(data);
        data4 = BIT4&(data);
        data5 = BIT5&(data);
        data6 = BIT6&(data);
        data7 = BIT7&(data);        
}


void send2callboxes(){                  // Needs: function parallel_write/ Global variables: TXBuffer, tx_clear / Configuration extern interrupt
        
        if ( tx_clear == 1)
        {   
            parallel_write( TXBuffer[0] );                  // Send the first position of TXBuffer first
            DataReady = 1;
                
        }else
        {
            uart0_text("Error: Overflow Parallel Write TX");        // Error if the transmission is still in use
        }
    
}


//*****************************************************************************
//                            EXTERN IRQ Handler
//*****************************************************************************

void get2(){   
    
    static uint16_t c = 1;       
    DataReady = 0;                              // Get Ready the new data
//    led3 = !led3;
    tx_clear = 0;

    if ( c < 300 ) 
    {
        parallel_write ( TXBuffer[c] ) ;        // Write the next data to be send
        DataReady = 1;                          // Allow the data to be capture
        
    }else{
//            led1 = 0;
//            led2 = 0;
//            led3 = 1;
//            led4 = 1;
            tx_clear = 1;                       // Allow the next package to the transmitted
            c = 0;
        }
    c++;
}