#ifndef __SIP_H__
#define __SIP_H__

#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "call.h"
#include "vz_protocol.h"
#include "debug.h"

#define __INVITE_MAX_WAITING_TIME__ 30
#define SIP_MAXFIELDSIZE 256
#define SIP_MAXMSGSIZE 2048
#define SIP_REGISTER_EXPIRES 120
#define DRAMBASEADDR    0xa0000000
#define SIP_ALLOW "Allow: ACK, BYE, CANCEL, INFO, INVITE, NOTIFY, OPTIONS, REFER"
/* #define SIP_ALLOW "Allow: ACK, BYE, CANCEL, INVITE, OPTIONS" */

//#define __SEVER_IP__ "192.168.120.120"
#define __SEVER_IP__ "192.168.30.25"
//#define __SERVER_PORT__ 5075
#define __SERVER_PORT__ 5060
#define __MY_PORT__ 5062
#define __MY_EXT__ 820
#define __PEER_EXT__ 913

#define sip_idle 0
#define sip_waiting_trying 1 << 1
#define sip_trying 1 << 2
#define sip_ringing 1 << 3
#define sip_busy 1 << 4
#define sip_ok 1 << 5
#define sip_on_call 1 << 6
#define sip_denied 1 << 7

class Sip{

private :
    int id;
    char server_ip[20];
    int  server_port;
    char my_ip[20];
    int  my_port;
    int  my_ext;
    int  my_rtp_port;
    char my_display[20];
    int  peer_ext;
    char fill_random_aux[ 65 ];
    char last_invite_tag[ SIP_MAXFIELDSIZE ];
    char last_invite_callid[ SIP_MAXFIELDSIZE ];
    char SVNREV[ 16 ];
    char buffer[ 1024 ];
    UDPSocket sock;
    Endpoint sip_server;
    void __init_sock__( void );
    void __end_sock__( void );
public :
    uint8_t status;
    Sip();
    Sip( int id, uint16_t my_port );
    Sip( int id, uint16_t my_port, int dest_ext );
    Sip( char * server_ip, int server_port, char * my_ip, int my_port, int my_ext, int peer_ext, int id );
    ~Sip();
    void registry( void );
    VZ_call * invite( void );
    
    char * make_content_length( char * header, char * body, char * pkg );
    
    int get_return_code( char * s );
    int get_cseq( void );
    int get_id( void );
    int get_my_rtp_port( void );
    
    char * build_registry_package( char * buffer );
    char * build_unregistry_package( char * buffer );
    char * build_invite_package( char * s, char * callbox_string, int * cseq );
    char * build_bye_package( char * buffer );
    char * build_ack_package( char * buffer, unsigned char * orig );
    char * build_generic_reply_package(char * s, unsigned char * orig, char * tag);
    char * build_trying_package( char * buffer, unsigned char * orig );
    char * build_busy_package( char * buffer, unsigned char * orig );
    char * build_reply_package( char * buffer, unsigned char * orig );
        
    char * fill_random16h(char * buffer );
    char * fill_random( char * buffer, int size );
    int fill_random_rtp_port( void );
    
    char * decode_cseq(unsigned char * package, char * cseq);
    char * decode_branch( unsigned char * package, char * branch );
    int decode_gettag( unsigned char * package, char * tag, char * out );
    
    void change_sip_server();
    char * get_next_server_ip( char *server_ip );
    int get_next_server_port();
    int get_next_server_ext();
    
    void set_server_ext( int new_server_ext );
    void set_server_port( int new_server_port );
    void set_ext( int ext );
    void set_port( int port );
    void set_server_ip( char * new_server_ip );
    
    int listen_SIP_server( void );
    void send_bye( void );
    void send_unregistry_pkg( void );
    
    uint8_t get_status( void );
};
#endif