#include "call.h"
#include "debug.h"

VZ_call::VZ_call( int cb_ext, int cb_port, int rtp_server_ext, int rtp_server_port ){
    this->cb_ext = cb_ext;
    this->cb_port = cb_port;
    
    this->rtp_server_ext = rtp_server_ext;
    this->rtp_server_port = rtp_server_port;
    this->rtp_server.set_address( __RPT_SEVER_IP__, rtp_server_port );
    rtp_sock.set_blocking( false, 3 );
    this->rtp_sock.bind( cb_port ); // rtp port
    this->rtp_sock.init();
    this->rtp = new RTP( this->cb_ext );
    
    t.start();
    finish.start();
    rtpbuf_clear( &( this->rtpbuf ) );
}

VZ_call::~VZ_call(){
    rtp_sock.close();
    delete( this->rtp );
}

char * VZ_call::get_eth_message( int * length ){
    uint8_t * pkg;
    *length = rtp_sock.receiveFrom( rtp_server, server2cb, sizeof( server2cb ) );
    t.reset();
    
    rtpbuf_next( &rtpbuf );
    
    if( *length > 0 ){
        rtpbuf_put( &rtpbuf, *length - ( __RTP_HEADER_SIZE__ + ( server2cb[ 0 ] & 0xf ) ), 
            ( uint8_t * )server2cb + ( __RTP_HEADER_OFFSET__ + ( server2cb[ 0 ] & 0xf ) ) );
    }
    
    pkg = rtpbuf_get( &rtpbuf );
    
    if (pkg != NULL) {
        *length = 240;
        return (char *) pkg;
    }
    led1 = !led1;
    *length = 0;
    return NULL;
}

int VZ_call::send_message( char * buffer  ){
    t.reset();
    return( this->rtp_sock.sendTo( this->rtp_server, buffer, __CB_AUDIO_DATA_SIZE__ + this->rtp->header_size() ) );
}

uint8_t * VZ_call::build_cb_package( void ){
    // return __build_cb_package__( cb_ext, cb_port, __AUDIO__, server2cb, buffer );
    // colocar esta funcao novamente pra envio de msg, assim como encapsular melhor a funcao
    // de criacao dos pacotes pro cb em algumas funcoes.
    return 0x00;
}

char * VZ_call::build_eth_package( uint8_t * buffer ){
    return this->rtp->build_eth_package( ( char * )buffer );    
}

int VZ_call::get_cb_ext(){ return this->cb_ext; }
int VZ_call::get_cb_port(){ return this->cb_port; }

int VZ_call::get_rtp_server_ext(){ return rtp_server_ext; }
int VZ_call::get_rtp_server_port(){ return rtp_server_port; }
uint8_t * VZ_call::get_cb2server_buffer(){ return cb2server; }
char * VZ_call::get_server2cb_buffer(){ return server2cb; }
inline uint8_t * VZ_call::get_buffer(){ return buffer; }

bool VZ_call::is_timeout( void ){
    return ( t.read() > __CALL_MAX_IDLE_TIME__ ) ? true : false;
}

bool VZ_call::is_timetofinish( void ){
    return ( finish.read() > __MAX_CALL_TIME__ ) ? true : false;
}