#include "rtp.h"

RTP_Header::RTP_Header( int cb_ext ){
    // por algum motivo do alem, comecar do 0 nao funcionou
    ss_id = 0x01010101 + ( uint32_t )cb_ext;
    seq_number = 0x0101;
    timestamp = 240;
}

RTP_Header::~RTP_Header(){
    // something
}

char * RTP_Header::build_header( char * pkg ){
    if( pkg == NULL ) return( NULL );
    
    for( register int i = 0; i < __RTP_HEADER_SIZE__; i++ ) pkg[ i ] = 0xff;

    pkg[ 0 ] &= 0x80;
    
    pkg[ 1 ] &= 0x08;

    pkg[ 2 ] = 0xff;
    pkg[ 2 ] &= ( char )( seq_number >> 8 );
    pkg[ 3 ] &= ( char )( seq_number & 0xff );
    
    pkg[ 4 ] &= ( char )( timestamp >> 24 & 0xff  );
    pkg[ 5 ] &= ( char )( timestamp >> 16 & 0xff );
    pkg[ 6 ] &= ( char )( timestamp >> 8 & 0xff );
    pkg[ 7 ] &= ( char )( timestamp & 0xff );
    
    pkg[ 8 ] &= ( char )( ss_id >> 24 & 0xff );
    pkg[ 9 ] &= ( char )( ss_id >> 16 & 0xff );
    pkg[ 10 ] &= ( char )( ss_id >> 8 & 0xff );
    pkg[ 11 ] &= ( char )( ss_id & 0xff );
    
    pkg[ __RTP_HEADER_SIZE__ ] = 0;
    timestamp += 240;
    seq_number++;
    
    return( pkg );
}

size_t RTP_Header::size( void ){
    return( __RTP_HEADER_SIZE__ );    
}

RTP_Body::RTP_Body(){
    // do something
}

RTP_Body::~RTP_Body(){
    // something
}

size_t RTP_Body::size( void ){
    return( sizeof( RTP_Body ) );    
}

char * RTP_Body::build_body( char * dest, char * buffer ){
    for( register int i = 0; i < __CB_AUDIO_DATA_SIZE__; i++ ) dest[ i ] = buffer[ i ];
    return( dest );
}

RTP::RTP( int ext ){
    rtp_header = new RTP_Header( ext );
    rtp_body = new RTP_Body();
}

RTP::~RTP(){
    if( rtp_header ) delete( rtp_header );
    if( rtp_body ) delete( rtp_body );
    debug_msg("Fui destruido");
}

char * RTP::build_eth_package( char * buffer ){
    rtp_header->build_header( this->pkg );
    rtp_body->build_body( this->pkg + __RTP_HEADER_OFFSET__, buffer );
    return( this->pkg );
}

size_t RTP::header_size( void ){
    return rtp_header->size();
}