#ifndef _RTPBUF_H
#define _RTPBUF_H

#include <stdint.h>

/* IMPORTANT: sizes must be multiple of 4 */
#define RTPBUF_PKGSIZE 240 /* 30ms @ 8Ksamples/sec */
#define RTPBUF_BUFSIZE 320 /* 40ms @ 8Ksamples/sec */

#if (RTPBUF_PKGSIZE & 0x03)
# error OPS... value forbidden
#endif
#if (RTPBUF_BUFSIZE & 0x03)
# error OPS... value forbidden
#endif

struct rtpbuf {
  uint32_t b[ RTPBUF_BUFSIZE>>2 ];
  int size;
};
typedef struct rtpbuf rtpbuf_t;

/* clear the buffer, useful at the start of a new phone call */
void rtpbuf_clear (rtpbuf_t * self);

/* use this function to put audio into the fifo */
void rtpbuf_put (rtpbuf_t * self, int size, uint8_t * data);

/* use this function to check if there is audio available
 * returns NULL if there is no audio available
 * or returns a pointer to the audio package */
uint8_t * rtpbuf_get (rtpbuf_t * self);

/* use this function to tell rtpbuf that you already consumed
 * the data supplied by rtpbuf_get() */
void rtpbuf_next (rtpbuf_t * self);

#endif