#ifndef __CALL_H__
#define __CALL_H__

#include "rtp.h"
#include "rtpbuf.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "object.h"
#include "vz_protocol.h"

extern DigitalOut led1;

#define __RPT_SEVER_IP__ "192.168.120.120" 
#define __CALL_MAX_IDLE_TIME__ 5 
#define __MAX_CALL_TIME__ 180

class VZ_call : public Object{
    private :
        Timer t;
        Timer finish;
        int cb_ext;
        int cb_port;
        uint8_t cb2server[ 320 ];
        char server2cb[ 320 ];
        uint8_t buffer[ 320 ];
        UDPSocket rtp_sock;
        int rtp_server_ext;
        int rtp_server_port;
        Endpoint rtp_server;
        RTP * rtp;
        rtpbuf_t rtpbuf;
    public :
        VZ_call( int cb_ext, int cb_port, int rtp_server_ext, int rtp_server_port );
        ~VZ_call();
        int get_cb_ext();
        int get_cb_port();
        int get_rtp_server_ext();
        int get_rtp_server_port();
        char * get_eth_message( int * length );
        char * get_server2cb_buffer();
        uint8_t * get_cb2server_buffer();
        uint8_t * get_buffer();
            
        uint8_t * build_cb_package( void );
        char * build_eth_package( uint8_t * );
        
        int send_message( char * );
        bool is_timeout( void );
        bool is_timetofinish( void );
};
#endif