#ifndef __UTILS_H__
#define __UTILS_H__

#include <iostream>
#include <string.h>
#include "debug.h"
#include "mbed.h"
#include "EthernetInterface.h"
#include "vz_protocol.h"
#include "vector.h"
#include "sip.h"
#include "call.h"
#include "call_box.h"
#include "timeslice.h"
#include "NTPClient.h"
#include "parallelcpld.h"
#include "test.h"

using namespace std;

extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;
#define set_status(a,b) _set_status(a,b)
#define _set_status(a,b){ \
  if( a != b ) debug_msg("Anterior %d -- Atual %d", a, b ); \
  if( a != NULL || b != NULL ) a = b; \
  else debug_msg("Paramento sip null"); \
}

void reverse( char str[], int length );
char* itoa(int num, char* str, int base);
void reset_leds( void );
int __init_eth__( EthernetInterface * eth );

Call_Box * __find_CB__( Vector * v_cb, int ext );
VZ_call * __find_Call__( Vector * v_call, int ext );
void registry_aging( Vector * v_cb, uint8_t * data, uint8_t * write_buffer );
int sip_manager( Vector * v_cb, Vector * v_call, uint8_t * write_buffer );
void call_manager( Vector * v_call, Vector * v_cb, uint8_t * data, uint8_t * write_buffer, Timeslice * ts );
void build_telemetry_report( int ext, int port, char * data );
void __send_to_cb__( uint8_t * buffer );

#endif