#include "utils.h"

void reverse( char str[], int length ){
    int start = 0;
    int end = length -1;
    while (start < end){
        swap(*(str+start), *(str+end));
        start++;
        end--;
    }
}
char* itoa(int num, char* str, int base){
    int i = 0;
    bool isNegative = false;

    if( num == 0 ){
        str[i++] = '0';
        str[i] = '\0';
        return str;
    }
    if( num < 0 && base == 10 ){
        isNegative = true;
        num = -num;
    }
    while( num != 0 ){
        int rem = num % base;
        str[i++] = (rem > 9)? (rem-10) + 'a' : rem + '0';
        num = num/base;
    }
    if( isNegative )
        str[i++] = '-';
    
    str[i] = '\0'; // Append string terminator

    reverse( str, i );
    return( str );
}

void reset_leds( void ){
    led1 = led2 = 1;
    led3 = led4 = 0;
}

int __init_eth__( EthernetInterface * eth ){
    //eth->init( __MY_IP__, "255.255.255.0", "192.168.120.1" );
    eth->init( "192.168.2.200", "255.255.255.0", "192.168.2.254" );
    
/*
#ifdef debug_colinas
#define __MY_IP__ "192.168.2.200"
#define __MY_GT__ "192.168.2.254"
#endif
#ifndef debug_colinas
#define __MY_IP__ "192.168.120.169"
#define __MY_GT__ "192.168.120.1"
#endif

#define __MY_MK__ "255.255.255.0"
*/
    return eth->connect();
    // pensar em o que acontece e como sinalizar que nao consegui conectar na web
    // aparente so da time out, so que algo vai travar quando eu tentar usar a conexao
}

Call_Box * __find_CB__( Vector * v_cb, int ext ){
    Call_Box * cb = NULL;
    for( register int i = 0; i < v_cb->size(); i++ ){
        cb = ( Call_Box * )v_cb->get_element( i );
        if( cb->get_ext() == ext ) return( cb );
    }
    return( NULL );
}

VZ_call * __find_Call__( Vector * v_call, int ext ){
    VZ_call * call = NULL;
    for( register int i = 0; i < v_call->size(); i++ ){
        call = ( VZ_call * )v_call->get_element( i );
        if( call->get_cb_ext() == ext ) return( call );
    }
    return( NULL );
}

void registry_aging( Vector * v_cb, uint8_t * data, uint8_t * write_buffer ){
    Call_Box * cb = NULL;
    if( v_cb && data && write_buffer ){
        for( register int i = 0; i < v_cb->size(); i++ ){
            cb = (Call_Box * )v_cb->get_element( i );
            if( cb->is_timeout() ){
                if( cb->reconfigure_timeout() == 0x00 ){
            //        debug_msg("( ext %d removed", cb->get_ext() );
                    //cb->unregistry();
                    //v_cb->remove_element( i );
                    //delete( cb );
                    break;
                }else{
              //      debug_msg("Ping on %d", cb->get_ext() );
                    
                    cb->set_msg_id( ( ( cb->get_msg_id() ) + 1 ) & ( BIT7 ^ 0xff ) );
                    
                    debug_msg("");
                    
                    __send_to_cb__( __build_cb_package__( cb->get_ext(), cb->get_port(), __REGISTRY__, 
                        ( char * )data, cb->get_msg_id(), __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__, write_buffer ) );
                    
                    debug_msg("");
                    
                    cb->registry();
                    
                    debug_msg("");
                }
            }
        }
    }
    /*
    Call_Box * cb = NULL;
    if( v_cb && data && write_buffer ){
        bool remove_slave = false;
        int slave = 0x00;
        int tam = v_cb->size();
        for( register int i = 0; i < v_cb->size(); i++ ){
            cb = (Call_Box * )v_cb->get_element( i );
            if( cb->get_ext() % 2 ) continue;
            if( cb->is_timeout() ){
                if( cb->reconfigure_timeout() == 0x00 ){
                    debug_msg("( ext %d removed", cb->get_ext() );
                    cb->unregistry();
                    slave = cb->get_ext() + 1;
                    remove_slave = true;
                    v_cb->remove_element( i );
                    delete( cb );
                    break;
                }else{
                    cb->set_msg_id( ( ( cb->get_msg_id() ) + 1 ) & ( BIT7 ^ 0xff ) );
                    __send_to_cb__( __build_cb_package__( cb->get_ext(), cb->get_port(), __REGISTRY__, 
                        ( char * )data, cb->get_msg_id(), __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__, write_buffer ) );
                    cb->registry();
                }
            }
        }
        if( remove_slave ){                
            for( register int i = 0; i < v_cb->size(); i++ ){
                cb = (Call_Box * )v_cb->get_element( i );
                if( cb->get_ext() == slave ){
                    debug_msg("( ext %d removed", cb->get_ext() );
                    cb->unregistry();
                    v_cb->remove_element( i );
                    delete( cb );
                }
            }
        }
        if( tam != v_cb->size() ) debug_msg("%d ---> %d", tam, v_cb->size() );
    }
    */
    //debug_msg("");
}

int sip_manager( Vector * v_cb, Vector * v_call, uint8_t * write_buffer ){
    static int index = 0;
    //debug_msg("");
    if( v_cb && write_buffer ){
        if( v_cb->size() > 0 ){
            //debug_msg("");
            if( index >= v_cb->size() ) index = 0;    
        }else return 0;
        Call_Box * cb = (Call_Box * )v_cb->get_element( index );
        /*  Retorna 
            = 0 :: ok
            < 0 :: tive problemas
            > 0 :: devo remover essa call do vetor de calls 
        */
        int returned_value = 0;
        
        if( cb->status == cb_on_call || cb->status == cb_idle ){
            //debug_msg("");
            returned_value = cb->listen_SIP_server();
        }
        index++;
        return( returned_value );
    }
    led1 = !led1;
    return( -1 );
}

/* remove calls por timeout */
void call_manager( Vector * v_call, Vector * v_cb, uint8_t * data, uint8_t * write_buffer, Timeslice * ts ){
    for( register int i = 0; i < v_call->size(); i++ ){
        VZ_call * call = ( VZ_call * )v_call->get_element( i );
        if( call->is_timeout() || call->is_timetofinish() ){
            v_call->remove_element( i );
            Call_Box * cb = __find_CB__( v_cb, call->get_cb_ext() );
            if( cb ){ 
                cb->status = cb_idle;
                ts->return_timeslice( cb->get_timeslice() );
                cb->set_timeslice( 0x00 );
                data[ __TIMESLICE_PLACE__ ] = 0x00;
                cb->set_msg_id( ( ( cb->get_msg_id() ) + 1 ) & ( BIT7 ^ 0xff ) );
                __send_to_cb__( __build_cb_package__( cb->get_ext(), cb->get_port(), __CB_BYE__, 
                    ( char * )data, cb->get_msg_id(), __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__, write_buffer ) );
                cb->send_bye();
                set_status( cb->sip->status, sip_idle );
            }
            delete( call );    
        }
    }    
}

void build_telemetry_report( int ext, int port, char * data ){
    // construir o pacote de telemetria aqui
    // decidir se isso sera escrito em disco e de tempos em tempos enviado para o servidor ... 
    // ou se sera enviado toda vez que determinado cb se registrar ...    
}

void __send_to_cb__( uint8_t * buffer ){
    xmemcpy( TXBuffer, buffer, DATA_SIZE );
    send2callboxes();
}