#include "mbed.h"
#include "stdint.h"
#include "configs.h"
#include "vz_protocol.h"
#include "parallelcpld.h"
//#include "debug.h"


uint8_t debug_alive = 1;

#define PVERSION 1          // Sempre atualizar a versao do prompt

#define DEBUGBUFSIZE 40
char debug_buf[DEBUGBUFSIZE];
FILE *fip,*fmask,*fgate,*fport,*fsip,*fsport; 
uint8_t dog = 1;
uint8_t debug_prompt = 0;
uint8_t bufptr = 0;
 

uint8_t xmemmatch(const uint8_t * s1, const uint8_t * s2, uint16_t size) {      // presente da lib.h pode retirar da versao final
  while (size--) {
    if (*s1++ != *s2++) return 0; /* does not match */
  }
  return 1; /* matches */
}

uint8_t xstrmatch(const uint8_t * s1, const uint8_t * s2) {                     // presente na lib.h pode retirar da versao final
  while (*s1) {
    if (*s1++ != *s2++) return 0; /* does not match */
  }
  if ( *s2 == 0 )
    return 1; /* matches */
  else
    return 0; /* does not match */
}

void xmemcpy(uint8_t * dest, const uint8_t * src, uint16_t size) {              // presente na lib.h pode retirar da versao final
  while (size--) *dest++ = *src++;
}


void cat(const char* fname)                                                     // Print the content of a given file
{
    char buff[513];
    int num;
    
    FILE *fp = fopen(fname, "r");
    if (fp == NULL) {
        pc.printf("Failed to open %s\n", fname);
        return;
    }
    
    while ((num = fread(buff, 1, 512, fp)) > 0)
    {
        buff[num] = '\0';
        pc.printf(buff);
    
    }
    fclose(fp);
}


void files (const char type) {                                          // operantion with the system config files
       
    if (type == 's' ){                // show files
        pc.printf("\n\r");
        pc.printf("1)IP, 2)MASK, 3)GATEWAY, 4)SIP PORT, 5)SERVER IP, 6)SERVER SIP PORT\n\r");
        cat("/qspi/myip.txt");
        cat("/qspi/mymask.txt");
        cat("/qspi/mygate.txt");
        cat("/qspi/mysipport.txt");
        cat("/qspi/serverip.txt");
        cat("/qspi/serverport.txt");
    }
    
    
    if (type == 'c' ){                // close all files
        fclose(fip);
        fclose(fmask);
        fclose(fgate);
        fclose(fport);
        fclose(fsip);
        fclose(fsport);
        
    }    
    
    if (type == 'i' ){                // Check if files exist, if not create the files
        fip = fopen("/qspi/myip.txt", "r");
        if (fip == NULL){
            fip = fopen("/qspi/myip.txt", "w");
            fprintf(fip, "192.168.120.169\n\r");   //myip
        }
        fmask = fopen("/qspi/mymask.txt", "r");
        if (fmask == NULL){
            fmask = fopen("/qspi/mymask.txt", "w");
            fprintf(fmask, "255.255.255.0\n\r");     //mymask
        }
        fgate = fopen("/qspi/mygateway.txt", "r");
        if (fgate == NULL){
            fgate = fopen("/qspi/mygate.txt", "w");
            fprintf(fgate, "192.168.2.254\n\r");    //mygateway
        }
        fport = fopen("/qspi/mysipport.txt", "r");
        if (fport == NULL){
            fport = fopen("/qspi/mysipport.txt", "w");
            fprintf(fport, "5075\n\r");  //mysipport
        }
        fsip = fopen("/qspi/serverip.txt", "r");
        if (fsip == NULL){
             fsip = fopen("/qspi/serverip.txt", "w");
             fprintf(fsip, "192.168.30.25\n\r");  //asterisk ip
        }
        fsport = fopen("/qspi/serverport.txt", "r");
        if (fsport == NULL){
            fsport = fopen("/qspi/serverport.txt", "w");
            fprintf(fsport, "5060\n\r");  //asterisk port
        pc.printf("\n\r Default configurations set! \n\r");
        }
        
    }
    
    if (type == 'r' ){                // Just open for read
        fip = fopen("/qspi/myip.txt", "r");
        fmask = fopen("/qspi/mymask.txt", "r");
        fgate = fopen("/qspi/mygateway.txt", "r");
        fport = fopen("/qspi/mysipport.txt", "r");
        fsip = fopen("/qspi/serverip.txt", "r");
        fsport = fopen("/qspi/serverport.txt", "r");
    }
        
    if (type == 'w'){                 // Create and write the default configs
        fip = fopen("/qspi/myip.txt", "w");
        fmask = fopen("/qspi/mymask.txt", "w");
        fgate = fopen("/qspi/mygateway.txt", "w");
        fport = fopen("/qspi/mysipport.txt", "w");
        fsip = fopen("/qspi/serverip.txt", "w");
        fsport = fopen("/qspi/serverport.txt", "w");   
        
        fprintf(fip, "192.168.120.169\n\r");   //myip
        fprintf(fmask, "255.255.255.0\n\r");     //mymask
        fprintf(fgate, "192.168.2.254\n\r");    //mygateway
        fprintf(fport, "5075\n\r");  //mysipport
        fprintf(fsip, "192.168.30.25\n\r");  //asterisk ip
        fprintf(fsport, "5060\n\r");  //asterisk port
        
        files('c');
        
        pc.printf("\n\r Default configurations set! \n\r");
             
    }
    
}

void init_fsystem(){                 // init file system and check if files exist
    //if (!qspifs.isformatted()) {
    //    qspifs.format();
    //    pc.printf("File system configured!!\n\r");
   // }
    
   // files('i');   // check if the files are created
   // files('c');
   // pc.printf("*******System Ready*******\n\r");
}


void prompt_process(){              // main prompt process
    volatile char b = 0;
    static uint8_t bufret = 0;
    static bool test = false;
    
    if (pc.readable()){
            
            b = pc.getc();
            
            if (b == 0x0D){
            bufret = 1;
            }
            else{
            pc.putc(b); 
            debug_buf[bufptr] = b;
            bufptr++;
            }
        }
        
    if (bufret == 1){                   // Prompt commands here
    
    
         if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "sconfig" )) {
             pc.printf("\n\r");
             files('s');
          }
 
         
          if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "format" )) {
             pc.printf("\n Formatando o sistema de arquivos... espere o sistema reiniciar \n\r");
             //qspifs.format();
             NVIC_SystemReset();
          }
          
          if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "ipset ",6 )) {
             fip = fopen("/qspi/myip.txt", "w");
             fprintf(fip,"%s\n\r",(debug_buf+6));
             fclose(fip);
             pc.printf("\n\r");
             files('s');
          }
          
        if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "maskset ",8 )) {
             fmask = fopen("/qspi/mymask.txt", "w");
             fprintf(fmask,"%s\n\r",(debug_buf+8));
             fclose(fmask);
             pc.printf("\n\r");
             files('s');
          }
          
        if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "gatewayset ",11 )) {
             fgate = fopen("/qspi/mygate.txt", "w");
             fprintf(fgate,"%s\n\r",(debug_buf+11));
             fclose(fgate);
             pc.printf("\n\r");
             files('s');
          }
         
          
         if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "msipport ",9 )) {
             fport = fopen("/qspi/mysipport.txt", "w");
             fprintf(fport,"%s\n\r",(debug_buf+9));
             fclose(fport);
             pc.printf("\n\r");
             files('s');
          }
          
          if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "serverip ",9 )) {
             fsip = fopen("/qspi/serverip.txt", "w");
             fprintf(fsip,"%s\n\r",(debug_buf+9));
             fclose(fsip);
             pc.printf("\n\r");
             files('s');
          }
          
         if( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "ssport ",7 )) {
             fsport = fopen("/qspi/serverport.txt", "w");
             fprintf(fsport,"%s\n\r",(debug_buf+7));
             fclose(fsport);
             pc.printf("\n\r");
             files('s');
          }
          
          
          if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "dconfig" )) {
            files('w');    
            files('s');
            
          }
          
         if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "reset" )) {
          pc.printf("\n\r reset!!! \n\r"); 
          pc.putc(0x01); 
          NVIC_SystemReset();
          }
          
          if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "dog" )) {
          pc.printf("\n\r MUUUUUUUuuuuUUUUUU - I'm not a dog!!!! \n\r");
          dog = 0;
          }
        
        if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "debug off" )) {
          pc.printf("Disable debug");
          debug_alive = 0;
        }
        
        if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "debug on" )) {
          pc.printf("Disable debug");
          debug_alive = 1;
        }
        
        if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "test on" )) {
            test = true;
        }
        
        if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "test off" )) {
            test = false;
        }
        
        if( test ){
            static int id_msg = 0x10;
            static int value = 0x00;
            char data[ 300 ];
            uint8_t write_buffer[ 300 ];
            for( register int i = 0; i < 300; i++ ) data[ i ] = value;
            
            if( ++value == 255 ){
                value = 0x00;
                pc.printf("\n\rPkgs enviados\n\r");
            }
            //__send_to_cb__( __build_cb_package__( 5002, 5002, __TEST__, data, id_msg++, __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__, write_buffer ) );
            //__send_to_cb__( __build_cb_package__( 5003, 5003, __TEST__, data, id_msg++, __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__, write_buffer ) );
        }
          
          
        if( xstrmatch( (uint8_t*)debug_buf, (uint8_t*) "help" )) {
         pc.printf("\n\r****************************PROMPT HELP******************\n\r");
         pc.printf("sconfig                 - mostra o arquivo de configuracao do sistema\n\r");
         pc.printf("dconfig                 - volta as configuracoes do sistema para o padrao de fabrica\n\r");
         pc.printf("callme [ramal porta]    - envia o pedido de ligacao para o callbox com o ramal e porta indicada\n\r");
         pc.printf("format                  - formata o sistema de arquivos\n\r");
         pc.printf("reset                   - resta o sistema\n\r");
         pc.printf("ipset [ip]              - Configura o IP da cabeceira\n\r");
         pc.printf("maskset [mask]          - Configura a mascara da cabeceira\n\r");
         pc.printf("gatewayset [gateway]    - Configura o gateway da cabeceira\n\r");
         pc.printf("msipport [port]         - Configura a porta SIP da cabeceira\n\r");
         pc.printf("serverip [ip]           - Configura o ip do servidor asterisk\n\r");
         pc.printf("ssport [port]           - Configura a porta SIP do servidor asterisk\n\r");
         pc.printf("\n\rPROMPT VERSION: V%d\n\r",PVERSION);
       }
        /*                  
        if ( xmemmatch( (uint8_t*)debug_buf, (uint8_t*) "callme ", 7 )) {
            if ( debug_buf[16] != 0 && debug_buf[11] != 0x20 )
                pc.printf("\n\r Error: formato errado! ramal=xxxx porta=xxxx \n\r");
            else {
                uint8_t data[300];
                uint16_t cks=0;
                
                //data[0] = (uint8_t)( (debug_buf[7]&0xf0)<<4 + (debug_buf[8]&0x0f) ) ;
                //data[1] = (uint8_t)( (debug_buf[9]&0xf0)<<4 + (debug_buf[10]&0x0f) ) ;
                //data[2] = (uint8_t)( (debug_buf[12]&0xf0)<<4 + (debug_buf[13]&0x0f) ) ;
                /data[3] = (uint8_t)( (debug_buf[14]&0xf0)<<4 + (debug_buf[15]&0x0f) ) ;
                
                data[0] = (uint8_t)( debug_buf[ 7 ] & 0xFF00 >> 8  );
                data[1] = (uint8_t)( debug_buf[ 9 ] & 0x00FF );
                data[2] = (uint8_t)( debug_buf[ 12 ] & 0xFF00 >> 8 );
                data[3] = (uint8_t)( debug_buf[ 14 ] & 0x00FF );
                
                data[6] = 0x04;
                for (int i = 7; i < 300; i++)  data[i] = 0x00;
                cks = __checksum__(data,300);
                data[4] = cks>>8;
                data[5] = cks&0xff;
                
                pc.printf("\n\r");
                for( int i = 0; i < 300; i++ )
                    pc.printf("%x ", data[ i ] );
                pc.printf("\n\r");
                
                xmemcpy(TXBuffer,data,300);
                
                pc.printf("\n\r");
                for( int i = 0; i < 300; i++ )
                    pc.printf("%x ", data[ i ] );
                pc.printf("\n\r");
                
                send2callboxes();
                
                pc.printf("\n\r calling callbox %s \n\r",debug_buf+7);
            }

        }
       */
    }

  if (b == 0x0D || bufret == 1 || bufptr > DEBUGBUFSIZE ){
    bufptr = 0;
    for (uint8_t i =0; i < DEBUGBUFSIZE; i++){
        debug_buf[i] = 0;
        }
    bufret = 0;
    pc.putc(0x0A);
    pc.putc(0x0D);
    }
}