#include "vz_protocol.h"
    
extern DigitalOut led2;
extern DigitalOut led3;
    
uint8_t * __parse_cb_buffer__( int * ext, int * port, volatile uint8_t * type, uint8_t * cb_buffer ){
    /**
    * parse and split vz package,
    * | E | E | P | P | C | C | T | [ Seq_num | Audio ] | 14[ Clock | Audio ] | [ TS | Audio ] | ... |
    * E = Ext = Ramal
    * P = Port = Porta
    * C = Checksum
    * T = Type = Tipo
    * Seq_num = Sequence Number = Numero de sequencia
    * Clock = 14 bytes to sync
    * ... = demais __CB_BUFFER_SIZE__ - __VZ_HEADER_OFFSET__  bytes
    */   
    uint8_t p_lsb, p_msb;
    uint8_t e_lsb, e_msb;
    
    if( cb_buffer == NULL ) return( NULL );
    
    uint16_t cc = ( uint16_t )cb_buffer[ 4 ] << 8 | cb_buffer[ 5 ];
    
    /*
    UDPSocket debug;
    Endpoint debug_server;
    char debug_msg[ 1024 ];
    
    debug_server.set_address( "192.168.120.180", 9897 );
    debug.bind( 8182 );
    debug.init();
    
    //if( cc != __checksum__( cb_buffer + __CHECKSUM_OFFSET__, 
    //    __CB_BUFFER_SIZE__ - __CHECKSUM_OFFSET__ ) ){
        
    sprintf( debug_msg, " -- cc :: %x :: __checksum %x -- bit[4] %x :: bit[5] %x", cc, __checksum__( cb_buffer, __CB_BUFFER_SIZE__ ), cb_buffer[ 4 ], cb_buffer[ 5 ] );
    debug.sendTo( debug_server, debug_msg, strlen( debug_msg ) );
    debug.sendTo( debug_server, debug_msg, strlen( debug_msg ) );
    */
    if( cc != __checksum__( cb_buffer, __CB_BUFFER_SIZE__ ) ){
            return( NULL );
    }else{
        e_msb = cb_buffer[ 0 ];
        e_lsb = cb_buffer[ 1 ];
        *ext = e_msb << 8  | e_lsb;
    
        p_msb = cb_buffer[ 2 ];
        p_lsb = cb_buffer[ 3 ];
        *port = p_msb << 8 | p_lsb; 
    
        *type = cb_buffer[ 6 ];

        return( cb_buffer + __VZ_HEADER_OFFSET__ );    
    }
}
uint8_t * __build_cb_package__( int ext, int port, uint8_t type, char * cb_buffer, uint8_t seq_num, int length,  uint8_t * pkg ){
    pkg[ 0 ] = ( uint8_t )( ( ext & 0xFF00 ) >> 8 );                                                                                      
    pkg[ 1 ] = ( uint8_t )( ext & 0x00FF );                                                                                                                                                                                                                                 
    pkg[ 2 ] = ( uint8_t )( ( port & 0xFF00 ) >> 8 );                      
    pkg[ 3 ] = ( uint8_t )( port & 0x00FF );
                                                                                                                                        
    pkg[ 6 ] = type;
    
    size_t fill = 0x00;
    
    if( type == __AUDIO__ ){
        for( register int i = __VZ_HEADER_OFFSET__; i < length + __VZ_HEADER_OFFSET__; i++ )
            pkg[ i ] = ( uint8_t )cb_buffer[ i - __VZ_HEADER_OFFSET__ ];
        fill = length + __VZ_HEADER_OFFSET__;
    }else if( type == __INVITE__ ){
        pkg[ 7 ] = seq_num;
        //__print_clock__( pkg + 8 );
        pkg[ __TIMESLICE_PLACE__ ] = cb_buffer[ __TIMESLICE_PLACE__ ];
        fill = __TIMESLICE_PLACE__ + 1;
    }else if( type == __REGISTRY__ || type == __BOOT__ ){
        pkg[ 7 ] = seq_num;
        __print_clock__( pkg + 8 );
        fill = __VZ_HEADER_OFFSET__ + __CLOCK_SYNC_SIZE__ + __SEQ_NUM_SIZE__;
    }if( type == __CB_BYE__ ){
        pkg[ 7 ] = seq_num;
        //__print_clock__( pkg + 8 );
        pkg[ __TIMESLICE_PLACE__ ] = cb_buffer[ __TIMESLICE_PLACE__ ];
        fill = __TIMESLICE_PLACE__ + 1;
    }
    
    for( register int i = fill; i < __CB_BUFFER_SIZE__; i++ ) pkg[ i ] = 0x00;    
    led2 = !led2;
    
    uint16_t cc = __checksum__( pkg, 300 );
    pkg[ 4 ] =( uint8_t )( ( cc & 0xFF00 ) >> 8) ;
    pkg[ 5 ] =( uint8_t )( cc & 0x00FF );
    
    return pkg;
}

char * __build_eth__package__( void ){
    return( NULL );    
}

uint8_t * __read_cb_buffer__( uint8_t * dest, uint8_t * src ){    
    for( register int i = 0; i < __CB_BUFFER_SIZE__; i++ ) *dest++ = *src++;
    return( dest );
}

uint8_t * __read_eth_buffer__( uint8_t * dest, uint8_t * src ){
    
    for( register int i = 0; i < __ETH_BUFFER_SIZE__; i++ ) *dest++ = *src++;
    
    return( dest );
}

uint8_t * __write_cb_buffer__( uint8_t * dest, uint8_t * src ){    
    for( register int i = 0; i < __CB_BUFFER_SIZE__; i++ ) *dest++ = *src++;
    return( dest );
}

uint8_t * __write_eth_buffer__( uint8_t * dest, uint8_t * src ){
    
    for( register int i = 0; i < __ETH_BUFFER_SIZE__; i++ ) *dest++ = *src++;
    
    return( dest );
}

uint16_t __checksum__( uint8_t * buffer, size_t length ){
    uint16_t cc = 0x00;
    buffer[ 4 ] = buffer[ 5 ] = 0x5a;
    for( register int i = 0; i < length; i++ ){
        cc += buffer[ i ];
        if( cc & BIT15 ){
            cc <<= 1;
            cc |= BIT0;
        }else{ cc <<= BIT0; }
    }
    cc ^= 0xffff;
    return cc; 
}

void __print_clock__( uint8_t * buffer ){
    NTPClient ntp;
    ntp.setTime( "200.192.232.8", 123, 3 );
    time_t seconds;
    // seconds = time(NULL);
    struct tm  ts;
    time( &seconds );                                                                                                                           
    ts = *localtime( &seconds );
    
    int ano = ts.tm_year + 1900;
    int mes = ts.tm_mon + 1;
    int dia = ts.tm_mday; 
    int hora = ts.tm_hour - 3;
    int min = ts.tm_min; 
    int sec = ts.tm_sec; 
    
    buffer[ 0 ] = ano / 1000;
    ano -= buffer[ 0 ] * 1000;
    buffer[ 1 ] = ano / 100;
    ano -= buffer[ 1 ]* 100;
    buffer[ 2 ] = ano / 10;
    ano -= buffer[ 2 ] * 10;
    buffer[ 3 ] = ano;
    buffer[ 4 ] = mes / 10;
    buffer[ 5 ] = mes % 10;
    buffer[ 6 ] = dia / 10;
    buffer[ 7 ] = dia % 10;
    buffer[ 8 ] = hora / 10;
    buffer[ 9 ] = hora % 10;
    buffer[ 10 ] = min / 10;
    buffer[ 11 ] = min % 10;
    buffer[ 12 ] = sec / 10;
    buffer[ 13 ] = sec % 10;
    
    /* convertendo pro ascii do nro */
    for( register int i = 0; i < 14; i++ ) buffer[ i ] += 0x30;
}