#include "call_box.h"

Call_Box::Call_Box( int ext, int port ){
    this->ext = ext;
    this->port = port;
    t.start();
    remaining_attempts = __MAX_ATTEMPTS__;
    timeout = __TIMEOUT__;
    //sip.set_ext( this->ext );
    //sip.set_port( this->port );
    msg_id = 0x00;
    timeslice = 0x00;
    status = cb_idle;
    //Sip sip( ext, port );
    //sip = NULL;
    sip = new Sip( ext, port );
}

Call_Box::~Call_Box( void ){
    if( sip != NULL ) delete( sip );   
}

int Call_Box::get_port( void ){ return( this->port ); }
int Call_Box::get_ext( void ){ return( this->ext ); }

float Call_Box::get_elapsed_time( void ){ return( this->t.read_ms() ); }

void Call_Box::reset_elapsed_time( void ){ 
    this->t.reset(); 
    remaining_attempts = __MAX_ATTEMPTS__;
    timeout = __TIMEOUT__;
}

bool Call_Box::is_timeout( void ){
    return( t.read() > timeout ) ? true : false;    
}

uint8_t Call_Box::reconfigure_timeout( void ){
    static int count = 1;
    if( timeout != __MAX_TIMEOUT__ ) timeout = __STEP__  * count++;
    t.reset();
    return( remaining_attempts-- );
}

void Call_Box::registry( void ){
    if( this->sip == NULL ){
        this->sip = new Sip( ext, port );
    
        sip->registry();
    
        delete( sip );
        this->sip = NULL;
    }else{
        sip->registry();
    }
}

void Call_Box::unregistry( void ){
    if( this->sip == NULL ){ 
        this->sip = new Sip( ext, port );
    
        sip->send_unregistry_pkg();
    
        delete( sip );
        this->sip = NULL;
    }else{
        sip->send_unregistry_pkg();
    }
}

VZ_call * Call_Box::invite( void ){
    if( this->sip == NULL ){
        debug_msg("entrei no invite");
        this->sip = new Sip( ext, port );
        
        VZ_call * call = sip->invite();
        
        delete( sip );
        this->sip = NULL;
        
        debug_msg("Valor do retorno do invite :: %p ", call );        
        return( call );
    }else{
        debug_msg("entrei no invite persistente");
        
        VZ_call * call = sip->invite();
        
        debug_msg("Valor do retorno do invite persistente :: %p ", call );        
        return( call );
    }
}

/*  Retorna 
    = 0 :: ok
    < 0 :: tive problemas
    > 0 :: devo remover essa call do vetor de calls 
*/
int Call_Box::listen_SIP_server( void ){
    if( this->sip == NULL ){
        if( status == cb_on_call || status == cb_idle ){
            this->sip = new Sip( ext, port );
            int out_read = sip->listen_SIP_server();
            delete( sip );
            this->sip = NULL;
            return( out_read );
        }else return( 0 );
    }else{
        if( status == cb_on_call || status == cb_idle ){
            return ( sip->listen_SIP_server() );
        } else return( 0 );
    }
}

void Call_Box::set_msg_id( uint8_t msg_id ){
    this->msg_id = msg_id;
}
uint8_t Call_Box::get_msg_id( void ){ return( this->msg_id ); }

void Call_Box::set_timeslice( uint8_t timeslice ){
    this->timeslice = timeslice;
}
uint8_t Call_Box::get_timeslice( void ){ return( this->timeslice ); }

//void Call_Box::set_sip( Sip * sip ){
//    this->sip = sip;    
//}

void Call_Box::send_bye( void ){ 
    if( this->sip == NULL ){
        this->sip = new Sip( ext, port );
        
        sip->send_bye();
        
        delete( sip );
        
        sip = NULL;
    }else{
        sip->send_bye();
    }
}

void Call_Box::reset_sip( void ){
    if( this->sip != NULL ) delete( this->sip );
    
    this->sip = new Sip( ext, port );
}