#ifndef __RTP_H__
#define __RTP_H__

#include <stdint.h>
#include <string.h>
#include "mbed.h"
#include "EthernetInterface.h"
#include "vz_protocol.h"
#include "debug.h"

#define __RTP_HEADER_OFFSET__ 12
#define __RTP_HEADER_SIZE__ 12

class RTP_Header{
    private :
        uint32_t ss_id;
        uint16_t seq_number;
        uint32_t timestamp;
    public  :
        RTP_Header( int cb_ext );
        ~RTP_Header();
        size_t size( void );
        uint8_t * build_header( uint8_t * buffer_header );
        char * build_header( char * pkg );
};

class RTP_Body{
    private :
    public  :
        RTP_Body();
        ~RTP_Body();
        size_t size( void );
        char * build_body( char * dest, char * buffer );
};
class RTP{
    private :
        uint8_t buffer[ 512 ];
        char pkg[ 512 ];
        RTP_Header * rtp_header;
        RTP_Body * rtp_body;
    public  :
        RTP( int ext );
        ~RTP();
        size_t header_size( void );
        char * build_eth_package( char * buffer );
        uint8_t * get_buffer( void ){ return this->buffer; }
};

#endif