#ifndef _CONFIGS_H
#define _CONFIGS_H
#include "mbed.h"

#define DATA_SIZE         300

extern DigitalOut led1;
extern DigitalOut led2;
extern DigitalOut led3;
extern DigitalOut led4;

extern DigitalOut DataReady;                  //IO 27        

extern DigitalOut data0;                      //LSB
extern DigitalOut data1;
extern DigitalOut data2;
extern DigitalOut data3;
extern DigitalOut data4;
extern DigitalOut data5;
extern DigitalOut data6;
extern DigitalOut data7;                      //MSB

extern InterruptIn NextData;                   //IO 96
extern InterruptIn FrameSync;
//Ticker ticker;                              // Timer para Debug

extern DigitalOut RST;                        // Pino de reset para o CPLD
extern DigitalIn PPD;                         // Pino de conexao com o cristal do CPLD

extern DigitalOut ENABLE_F_REG;               // Configuracao da Alimentacao do CPLD
extern DigitalOut ENABLE_F_RX;
extern DigitalOut ENABLE_F_TX;

extern Serial  Uart3;  // default baudrate = 9600; Sem paridade, 8bits, 1 stop-bit 
extern Serial  pc ;

void start_cpld( void );
void config_lpc( void );
void uart3_puts(uint8_t *src, uint16_t size);
void uart0_puts( uint8_t *src );
void uart0_text( const char* src);
void uart0_putsx(volatile uint8_t *src );
void xmemcpy(uint8_t * dest, uint8_t * src, uint16_t size);


#endif
