#ifndef _VZ_PROTOCOL_H__
#define _VZ_PROTOCOL_H__

#include <stdlib.h>
#include <stdint.h>
#include <string.h>
#include "rtp.h"
#include "NTPClient.h"
#include "bits.h"
// 7 + 14 + 1 == ts

#define __VZ_HEADER_OFFSET__ 7
#define __CB_BUFFER_SIZE__ 300
#define __ETH_BUFFER_SIZE__ __CB_BUFFER_SIZE__ + __RTP_HEADER_SIZE__ + 1 // 313  
#define __CB_AUDIO_DATA_SIZE__ 240
#define __CHECKSUM_OFFSET__ 7
#define __SEQ_NUM_SIZE__ 1
#define __CLOCK_SYNC_SIZE__ 14
#define __TIMESLICE_PLACE__ 22
#define __UDP_PORT__ 7890 /* numeros arbitrarios ... */
#define __TCP_PORT__ 8709

#define __MAX_CB_IN_A_BRANCH__ 40
#define __READ__ 0x01
#define __WAITING__ 0x00

// types
#define __BOOT__ 0x00
#define __REGISTRY__ 0x02
#define __INVITE__ 0x04
#define __AUDIO__ 0x08
#define __TELEMETRY__ 0x10
#define __CB_BYE__ 0x20
#define __SOMETHING_2__ 0x40
#define __SOMETHING_3__ 0x80

#define __DO_NOTHING__ 0x99

#define __MY_IP__ "192.168.120.169"

uint16_t __checksum__( uint8_t * buffer, size_t length );

/* incorporar a parte de cc */
uint8_t * __parse_cb_buffer__( int * ext, int * port, volatile uint8_t * type, uint8_t * cb_buffer );
uint8_t * __build_cb_package__( int ext, int port, uint8_t type, char * cb_buffer, uint8_t seq_num, int length,  uint8_t * pkg );
char * __build_eth__package__( void );
void __print_clock__( uint8_t * buffer );

extern void uart3_puts(uint8_t *src, uint16_t size);

/* mais pra frente isso vira os cpld_send and cpld_receive */
uint8_t * __read_cb_buffer__( uint8_t * dest, uint8_t * src );
uint8_t * __read_eth_buffer__( uint8_t * dest, uint8_t * src );
uint8_t * __write_cb_buffer__( uint8_t * dest, uint8_t * src );
void __send_to_cb__( uint8_t * buffer );
uint8_t * __write_eth_buffer__( uint8_t * dest, uint8_t * src );


#endif