#include "vector.h"

Vector::Vector(){
    this->objects = NULL;
    this->elements = 0;
}

Vector::~Vector(){
    if( this->objects != NULL ) free( this->objects );  
}

void Vector::add( Object * e){
    this->objects = ( Object ** )realloc( this->objects, sizeof ( Object * ) * ++this->elements );
    this->objects[ this->elements - 1 ] = e;
}

Object * Vector::get_element( int position ){
    return( position > -1 && position < this->elements ) ? (Object *) * ( this->objects + position ) : NULL;
}

void Vector::remove_element( int position ){
    if( position > -1 && position < this->elements ){
        if( position == 0 && this->elements == 1 ) {
            this->elements = 0;
            free( this->objects );
            this->objects = NULL;
        }else{
            this->objects[ position ] = this->objects[ --this->elements ];
                    this->objects = ( Object ** )realloc( this->objects, sizeof ( Object * ) * this->elements );
        }
    }
}

int Vector::find_element( Object * e ){
    for( int i = 0; i < this->elements; i++ )
        if( this->objects[ i ] == e ) return ( i );
    return ( -3 );
}

//Object * Vector::find_element( int ext, int port ){
//    for( int i = 0; i < this->elements; i++ ){
//        if( this->objects[ i ]->get_ext() == ext && 
//            this->objects[ i ]->get_port() == port ) return( this->objects[ i ] );
//    }
//    return( NULL );
//}

int Vector::size(){ return this->elements; }