#include <stdlib.h>

#include "debug.h"
#include "rtpbuf.h"

static void xmemcpy32(uint32_t * dest, uint32_t * src, uint16_t size) {
  size >>= 2;
  while (size--) *dest++ = *src++;
}

static void xmemcpy(uint8_t * dest, uint8_t * src, uint16_t size) {
  while (size--) *dest++ = *src++;
}

/*
rtpbuf_t * rtpbuf_init(void) {
    }
void rtpbuf_destroy(rtpbuf_t ** self) {
  free(*self)
*self = NULL;
}
*/

void rtpbuf_clear (rtpbuf_t * self) {
  self->size = 0;
}

void rtpbuf_put (rtpbuf_t * self, int size, uint8_t * data){
  if ((size + self->size) <= RTPBUF_BUFSIZE){
    xmemcpy((uint8_t*)self->b+self->size,data,size);
    self->size += size;
    //debug_msg("put %d -> %d",size,self->size);
  } else {
    //debug_msg("put-failed %d -> %d",size,self->size);
  }
}

uint8_t * rtpbuf_get (rtpbuf_t * self) {
  if (self->size < RTPBUF_PKGSIZE) {
    //debug_msg("get-failed %d", self->size);
    return NULL;
  }
  //debug_msg("get %d", self->size);
  return (uint8_t*) self->b;
}

void rtpbuf_next (rtpbuf_t * self) {
  if (self->size < RTPBUF_PKGSIZE) {
    //debug_msg("next-failed %d", self->size);
  } else {
    //int i;
    //i = self->size;
    self->size -= RTPBUF_PKGSIZE;
    if (self->size > 0) {
      xmemcpy32(self->b, (self->b)+(RTPBUF_PKGSIZE>>2), self->size);
      //debug_msg("nextA %d -> %d", i, self->size);
    } else {
      //debug_msg("nextB %d -> %d", i, self->size);
    }
  }
}