#include "configs.h"
#include "mbed.h"
#include <stdint.h>
#include "UART3Interrupt.h" 
#include "parallelcpld.h"

//*****************************************************************************
//                             Pins/Modules Config
//***************************************************************************** 

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

DigitalOut DataReady(p11);                  //IO 27        

DigitalOut data0(p30);                      //LSB
DigitalOut data1(p31);
DigitalOut data2(p32);
DigitalOut data3(p33);
DigitalOut data4(p34);
DigitalOut data5(p37);
DigitalOut data6(p38);
DigitalOut data7(p39);                      //MSB

InterruptIn NextData(p8);                   //IO 96
InterruptIn FrameSync(p17);                 // GCLK1

//Ticker ticker;                            // Timer para Debug

DigitalOut RST(p29);                        // Pino de reset para o CPLD
DigitalIn PPD(p25);                         // Pino de conexao com o cristal do CPLD

DigitalOut ENABLE_F_REG(p18);               // Configuracao da Alimentacao do CPLD
DigitalOut ENABLE_F_RX(p19);
DigitalOut ENABLE_F_TX(p20);

Serial  Uart3(p9,p10);  // default baudrate = 9600; Sem paridade, 8bits, 1 stop-bit 
Serial  pc (USBTX,USBRX);

void start_cpld( void ) {                        //CPLD Start

    static uint16_t reset = 10000;
    ENABLE_F_REG = 1;                                
    ENABLE_F_TX = 1;
    ENABLE_F_RX = 1;
    DataReady = 0;
    RST = 1;
    while(reset--){}
    RST = 0;        
}

void config_lpc( void ) {                                       // Configure LPC4088

    Uart3.attach(&SerialRecvInterrupt, Uart3.RxIrq);       // UART3_IRQ configuration 
    Uart3.format(8,SerialBase::Forced1,1);                 // UART3 mode configuration
    Uart3.baud(2000000);                                
    NVIC_SetPriority(UART3_IRQn,1);    
    pc.baud(115200);                                        // USART to PC USB USART
    NextData.rise(&get2);                                 // Extern Pin Interrupt
    FrameSync.rise(&RXFrameSync);                         // FrameSync for RX - Interrupt
    __enable_irq();
    //ticker.attach(&timer,0.01);                         // Timer para Debug    
}

static uint8_t itoh[16];
static uint8_t hexbuf[10];

uint8_t *hextoascii ( uint8_t src ) {
  
  hexbuf[0] = itoh[(src>>4) & 0x0f];  
  hexbuf[1] = itoh[src & 0x0f];
  hexbuf[2] = 0;
  return hexbuf;
    
}

void uart3_puts(uint8_t *src, uint16_t size){         // Print a string in UART3
    while (size--){
        while ( !(LPC_UART3->LSR &= (1<<5)) ) {} 
        LPC_UART3->THR = *src++;
    }
}

void uart0_puts( uint8_t *src) {         // Print a string in UART3
  
   uint16_t size = 300;
    
    while (size--){
        while ( !(LPC_UART0->LSR & (1<<5)) ) {} 
        LPC_UART0->THR = *src++;
    }
}

void uart0_putsx(volatile uint8_t *src ){            // Print a string in UART0   
    uint16_t size = 300;//sizeof( src ); 
    uint8_t *buff;
    while (size--)
    {   
        buff = hextoascii(*(src++));
        for ( uint8_t i  = 0; i < 3; i++ ){
            while ( !(LPC_UART0->LSR &= (1<<5))  ) {} 
            LPC_UART0->THR = buff[i];           //*src++;
        }
    }
}

void uart0_text( const char* src){                      // Print a string of constant in UART0
    static uint16_t size;
    size = sizeof (src);
    while (size--){
        while ( !(LPC_UART0->LSR &= (1<<5))  ) {} 
        LPC_UART0->THR = *src++;   
    }
}

void xstrcpy(uint8_t * dest, const uint8_t * src) {
  while (*src)  *dest++ = *src++;
  *dest = 0; 
}

void xmemcpy(uint8_t * dest, uint8_t * src, uint16_t size){
  while (size--) *dest++ = *src++;
}