#include "mbed.h"
#include "mbed_events.h"
#include "MPU6050.h"
#include "MPU6050_user.h"

Serial pc(USBTX,USBRX);     // default baud rate: 9600
MPU6050 mpu6050;            // class: MPU6050, object: mpu6050
MPU6050_user mpu6050_user;  // uzivatelske funkce pro MPU6050
Ticker filter;              // casovac pro spousteni vycitani dat z MPU6050

EventQueue eventQueue;      // vytvoreni uzivatelske fronty

void compFilter();          // definice procedury pro vycitani dat z MPU6050

float pitchAngle = 0;
float rollAngle = 0;


int main()
{
    // ###### inicializace periferii ######
    pc.baud(9600);                                      // rychlost komunikace: 9600
    mpu6050.getDeviceID();                              // test komunikace: vycteni registru WHO_AM_I
    wait(1);
    mpu6050_user.calibrate(accelBias,gyroBias);         // kalibrace MPU6050 a nahrání hodnot bias do bias registru
    pc.printf("Calibrace je kompletni.\r\n");
    wait(0.5);
    mpu6050.initialize();                               // inicializace sensoru
    wait(1);
    pc.printf("MPU6050 je inicializovan a funkcni..\r\n\r\n");
    wait_ms(500);
    // ###### konec inicializace periferii ######

    // ###### uvodni procedury a vytvoreni programovych vlaken ######
    // vytvoreni vlakna s normalni prioritou
    Thread eventThread(osPriorityNormal);
    eventThread.start(callback(&eventQueue, &EventQueue::dispatch_forever));

    filter.attach(eventQueue.event(&compFilter), 0.005); //1.0f);
    //filter.attach(&compFilter, 0.005);    // Call the complementaryFilter func. every 5 ms (200 Hz sampling period)
    //I2C je pomala a nelze spustit primo pres casovac. Vycitani z I2C je tedy nutno spoustet jako samostatne vlakno programu

    // ###### konec uvodni procedury a vetvoreni programovych vlaken ######

    while (1) {
/*        int x = mpu6050.getRotationX();
        int y = mpu6050.getRotationY();
        int z = mpu6050.getRotationZ();
        int t = mpu6050.getTemperature();
        pc.printf("Neco= %i %i %i %i\r\n",x,y,z,t);
        wait(1);
*/
        pc.printf(" _____________________________________________________________  \r\n");
        pc.printf("| Accelerometer(g) | ax=%.3f | ay=%.3f | az=%.3f                \r\n",ax,ay,az);
        pc.printf("| Gyroscope(deg/s) | gx=%.3f | gy=%.3f | gz=%.3f                \r\n",gx,gy,gz);
        pc.printf("|_____________________________________________________________  \r\n\r\n");
        
        wait(2.5);

        pc.printf(" _______________\r\n");
        pc.printf("| Pitch: %.3f   \r\n",pitchAngle);
        pc.printf("| Roll:  %.3f   \r\n",rollAngle);
        pc.printf("|_______________\r\n\r\n");

    }


}

void compFilter() { mpu6050_user.complementaryFilter(&pitchAngle, &rollAngle); }
