#include "mbed.h"
#include "BQ25896.h"

Serial pc(p29, p30, "debug", 115200);

BQ25896 bq25896(p28, p2);

uint8_t chargeState = 0;

void initBQ25896(void){
    pc.printf("init BQ25896\n\r");
    bq25896.reset();
    bq25896.disableWATCHDOG(); // disable Watchdog
    bq25896.disableILIMPin();
    bq25896.setIINLIM(3250); // mA
    bq25896.setBOOSTV(4900);//5000);//
    bq25896.setICHG(1280);   // Fast Charge Current Limit 1280
    bq25896.setBOOST_LIM(6); // BOOST_LIM 2.15A
    wait(1);
    bq25896.oneShotADC();
    if(bq25896.getVBUSV() < 4.00){
        bq25896.enableOTG();
    }
}

void checkChargingState(void){
    
    bq25896.oneShotADC();
    float voltage = bq25896.getVBUSV();
    if(chargeState == 0){
        if (voltage >= 4.95){
            pc.printf("charger detected  %2.3f\n\r", voltage);
            chargeState = 1;
            bq25896.disableOTG();
        }
    } else if (chargeState == 1){
        if (voltage < 4.00){
            pc.printf("charger removed %2.3f\n\r", voltage);
            chargeState = 0;
            bq25896.enableOTG();
        }
    }
}

int main()
{
    initBQ25896();
    while(true){
        wait(1);
        checkChargingState();
    }
}