#include "CMPS03.h"

CMPS03::CMPS03(PinName pwm) : _boussole(pwm)
{
    _boussole.rise(callback(this, &CMPS03::rise));
    _boussole.fall(callback(this, &CMPS03::fall));
    _boussole.enable_irq();
    _tim.start();
}

void CMPS03::rise(void)
{
    _startTime = _tim.read_us();
}

void CMPS03::fall(void)
{

    _stopTime = _tim.read_us();
    _pwmBearing = ((double)(_stopTime - _startTime - 1000)/100.0);
}


double CMPS03::getBearing(void)
{
    return _pwmBearing;
}

CMPS03::operator double()
{
    return _pwmBearing;
}
