#include "mbed.h"
#include "TextLCD.h"

PinName rowPins[4] = { PA_13, PA_14, PC_2, PC_3 };
PinName colPins[4] = { PA_0, PA_1, PA_4, PB_0 };

DigitalOut* _rows[4];
DigitalIn* _cols[4];

TextLCD lcd(D2,D3,D4,D5,D6,D7);

// Define your own keypad values
char Keytable[] = {
    '1', '2', '3', 'A', // r0
    '4', '5', '6', 'B', // r1
    '7', '8', '9', 'C', // r2
    '*', '0', '#', 'D'  // r3
  // c0   c1  c2   c3
};

int getKeyIndex() {
    int result = -1;
    for (int r = 0; r < 4 && result == -1; r++) {
        _rows[r]->write(1);
        for(int c = 0; c < 4 && result == -1; c++){
            DigitalIn *col = _cols[c];
            if(col->read() == 1) {
                result = r*4+c;
            }
        }
        _rows[r]->write(0);
    }
    return result;
}

char getKey() {
    int idx = getKeyIndex();
    return idx != -1 ? Keytable[idx] : '\0';
}

void init() {
    for(int i = 0;i < 4; i++){
        _rows[i] = new DigitalOut(rowPins[i]);
        _rows[i]->write(0);
    }
    for(int i = 0;i < 4; i++){
        _cols[i] = new DigitalIn(colPins[i],PullDown);
    }
}

int main() {
    char key;
    lcd.locate(0,0);
    lcd.printf("Clean");

    init();

    while(1) {
        key = getKey();
        lcd.locate(0,1);
        if (key != '\0') {
            lcd.printf("%c", key);
        } else  {
            lcd.printf("%c", ' ');
        }
    }
}
