#include "mbed.h"

#include "mbed.h"

DigitalOut led(LED1);
InterruptIn timer(D11); 
InterruptIn resetTimer(D7); 

Timer t;

int last_read = 0;


typedef struct time_screen {
   int cents;
   int seconds;
   int minutes;
} measured_time;

//Conversione da millisecondi a mm:ss:cc
measured_time human_read(int ms){
    measured_time read;
    div_t qr = div(ms,1000);
    
    read.cents = qr.rem % 100;
    
    qr = div(qr.quot,60);
    read.seconds = qr.rem;
    
    qr = div(qr.quot,60);
    read.minutes = qr.rem;
    
    return read;    
}


void accendiled(){
     int read = t.read_ms();
     if(read - last_read > 5000){
        int lap_time = read - last_read;
        measured_time time = human_read(lap_time);
        printf("Giro %02d:%02d:%02d \r\n",time.minutes,time.seconds,time.cents);
        last_read = read; 
      }
     
     
}

void stopTimer(){
     t.stop();
     
     int read = t.read_ms();
     measured_time time = human_read(read);
     printf("Totale %02d:%02d:%02d \r\n",time.minutes,time.seconds,time.cents);
     
     t.reset();
     t.start();
}

int main() {
    timer.mode(PullUp);
    timer.rise(&accendiled);  
    
    resetTimer.mode(PullDown);
    resetTimer.rise(&stopTimer);  
    
    
    t.start();
    
     while(true) {
       led = !led;
       wait(0.3f);
     }
    
    
}
