#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);


PinName rowPins[4] = { PB_0 , PA_4 , PA_1 , PA_0 };
PinName colPins[4] = { PA_13 , PA_14 , PC_14 , PC_15  };

DigitalOut* _rows[4];
DigitalIn* _cols[4];

TextLCD lcd(D2,D3,D4,D5,D6,D7); 

void printKeyBoard(){
    //lcd.cls();
    
    
    lcd.locate(0,0);
    lcd.printf("KeyBoard: ");
    
    lcd.locate(0,1);
    for(int i = 0;i < 4 ;i++){
        DigitalOut *row = _rows[i];
        
        char level = 'L';
        if(row->read() == 1){
            level = 'H';
        }
        lcd.printf( "%c" , level);
    }
    
    lcd.printf( "%c" , " ");
    
    
    for(int i = 0;i < 4;i++){
         DigitalIn *col = _cols[i];
        
        char level = 'L';
        if(col->read() == 1){
            level = 'H';
        }
        lcd.printf( "%c" , level);
    }
        
}

int main() {
    
    lcd.locate(0,0);
    lcd.printf("Clean");
    
    
    for(int i = 0;i < 4; i++){
        _rows[i] = new DigitalOut(rowPins[i]);
        _rows[i]->write(0);
    }
    for(int i = 0;i < 4; i++){
        _cols[i] = new DigitalIn(colPins[i],PullDown);
    }
   
    
    while(1) {
        for (int i = 0; i < 4; i++) {
            _rows[i]->write(1);
            printKeyBoard();
             wait(0.5);
            _rows[i]->write(0);
        }
    }
}
