#include "mbed.h"
#include "timer0.h"


//--------------------------------------------------------
// Construktor initialisiert den Timer
timer0::timer0()
{
    uint8_t i;
    
    ms = 0;
    sec = 0;
    
    // Initialize countdown timers
    for (i=0; i < TIMER0_NUM_COUNTDOWNTIMERS; i++)
      CountDownTimers[i].status = 0xFF;
  
    ticker.attach_us(this, &timer0::func, 1000);
}

//--------------------------------------------------------
// Interruptroutine wird jede ms aufgerufen
void timer0::func(void)
{
    uint8_t i;
    
    if(counter != 0) counter--;

    // Zeitbasis für Systemzeit
    // ----- count down timers in ms -------------------------------------------------
    for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++) 
    {
        if (CountDownTimers[i].status == 1) 
        {       // ms
            if (CountDownTimers[i].count_timer > 0)
                CountDownTimers[i].count_timer -- ;
            if (CountDownTimers[i].count_timer == 0)
                CountDownTimers[i].status = 0;
        }
    }
    
    if (ms < 1000) 
    {
        ms++;  
    }
    else
    {
        ms = 0;
       
        seconds++;
        set_time(seconds);
       
        // ----- count down timers in s -------------------------------------------------
        for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++) 
        {
            if (CountDownTimers[i].status == 2) 
            {   // sekunden
                if (CountDownTimers[i].count_timer > 0)
                    CountDownTimers[i].count_timer -- ;
                if (CountDownTimers[i].count_timer == 0)
                    CountDownTimers[i].status = 0;
            }
        }
        
        if (sec < 60) 
        {
            sec++;
        }
        else
        {
            sec = 0; 
            
            // hier folgt der Minutenzähler falls erforderlich           
        }   
    }
    
}

//--------------------------------------------------------
// Abfrage nach freiem Timer
//
// wenn alle Timer belegt sind wird 0xFF zurückgegebne

uint8_t timer0::AllocateCountdownTimer (void)
{
    uint8_t i;
    
    for (i=0; i<TIMER0_NUM_COUNTDOWNTIMERS; i++)
        if (CountDownTimers[i].status == 0xFF)
        {
            CountDownTimers[i].status = 0x00;   // Timer reserviert, nicht gestartet
            // printf_P(PSTR("\rallocate timer [%03d] %d\n"),i,ListPointer);            
            
            return i;
        }

    return 0xFF;
}

//--------------------------------------------------------
// Timer wieder freigeben
void timer0::RemoveCountdownTimer(uint8_t timer)
{
    CountDownTimers[timer].status = 0xFF;
}

//--------------------------------------------------------
// Abfrage ob Timer 0 erreicht hat                  
uint8_t timer0::GetTimerStatus(uint8_t timer)
{
    return CountDownTimers[timer].status;
}

//--------------------------------------------------------
// Abfrage der verbleibenden Zeit               
uint16_t timer0::GetTimerZeit(uint8_t timer)
{
    return CountDownTimers[timer].count_timer;
}

//--------------------------------------------------------
// Timer aktivieren
void timer0::SetCountdownTimer(unsigned char timer, unsigned char status, unsigned short value)
{
    CountDownTimers[timer].count_timer = value;
    CountDownTimers[timer].status = status;
}

//--------------------------------------------------------
// Zeitstempel setzen
void timer0::Set_t(uint8_t * data)
{
    char buffer[40];    
    
    t.tm_sec  = data[0];     // Sekunden 0-59
    t.tm_min  = data[1];     // Minuten 0-59
    t.tm_hour = data[2];     // Stunden 0-23
    t.tm_mday = data[3];     // Tag 1-31
    t.tm_mon  = data[4] - 1; // Monat 0-11 0 = Januar
    t.tm_year = data[5];     // Jahr year since 1900   
    
    seconds = mktime(&t);
    set_time(seconds);
    
    strftime(buffer, 40, "%a,%d.%m.%Y %H:%M:%S", localtime(&seconds));
    // pc.printf("\ntimer0::set_t = %s", buffer);   
}
