#include "mbed.h"
#include "USBMSD_SD.h"
#include "SDFileSystem.h"
#include "MODSERIAL.h"
#include "mon.h"
#include "com.h"
#include "menu.h"
#include "myTextLCD.h"
#include "timer0.h"

#define LED_OFF 1
#define LED_ON  0
#define COM_LINE_LEN 128              // maximale Länge der Eingabezeile  
#define TEL_SIZE 10

#define TIMER0_NUM_COUNTDOWNTIMERS  25
   
// LCD's für Anzeige
DigitalOut led1(PTB18);
DigitalOut led2(PTB19);
DigitalOut led3(PTB17);

// Taster für die Eingabe
DigitalIn S1(PTC7);
DigitalIn S2(PTC8);
DigitalIn S3(PTC9);
DigitalIn S4(PTC10);
DigitalIn S5(PTC11);

timer0 down_timer;          // Timer für Zeitsteuerung

MODSERIAL pc(USBTX,USBRX); 

SDFileSystem sd(PTD2, PTD3, PTD1, PTD0, "sd"); 

menu menu_var;

//MODSERIAK uart1(PTC4, PTC3, 512); // tx, rx
MODSERIAL uart1(PTC4, PTC3); // tx, rx

TextLCD lcd(PTE24, PTE25, PTE20, PTE21, PTE22, PTE23); // rs, e, d4-d7
PwmOut lcd_kontrast(PTA5); // Kontrast wird über PWM gesteuert
DigitalOut lcd_bl(PTE29);  // Hintergrundbeleuchtung

monitor mon;

uint8_t tasten, tasten_old;

//-----------------------------------------------------------------------------
// main
//
//
int main() 
{
    tasten = 0; 
    tasten_old = 0; 
    
    S1.mode(PullUp);
    S2.mode(PullUp);
    S3.mode(PullUp);
    S4.mode(PullUp);
    S5.mode(PullUp);
       
    // pc.printf("\ntimer0::set_t = %s", buffer); 
    
    lcd_bl = 6;         // Hintergrundbeleuchtung LCD Anzeige einschalten

    // die Zeiten müssen so kurz sein, da die LCD Anzeige sonst flackert
    lcd_kontrast.period_us(100);          // 100µs Periode
    lcd_kontrast.pulsewidth_us(30);       // 30 µs Pulszeit    
 
    // pc ist die USB Schnittstelle des Debuggers
    pc.baud(56700);    
    pc.printf("\nSD_USB_FS V09.01g");   
    pc.printf("\n V08 was compiled on %s  %s \n", __DATE__,__TIME__);
       
    // auf USB Mode umschalten
    S5.mode(PullUp);
    
    if (S5 == 0)
    {
        //          0123456789012345
        lcd.printf(" -- USB Mode -- ");
        lcd.writeLCD();
        
        USBMSD_SD msd(PTD2, PTD3, PTD1, PTD0);
        while(1);
    }
      
    //          0123456789012345
    lcd.printf(" - nomal Mode - ");  
    lcd.writeLCD();
    pc.printf("\nnormal SD mode\n");

    // uart1 ist die Schnittstelle zur microSPS    
    uart1.baud(115200);
    com_init();
        
    down_timer.SetCountdownTimer(0,1,50);  // Timer für Tasten
    down_timer.SetCountdownTimer(1,1,500); // Timer für LED
    down_timer.SetCountdownTimer(2,1,1000);// Timer für die Ausgabe der Daten
 
    while(1)
    {
        mon.monPC();
        com_line();
        
        //--------------------------------------------------------------------------
        // LED für Statusanzeige              
       
        if (down_timer.GetTimerStatus(1) == 0)
        {
            down_timer.SetCountdownTimer(1,1,500);    // alle 500ms                                          
            led1 = !led1;           // blaue oder gründe LED
            //led2 = !led2;
        }    
        
        //--------------------------------------------------------------------------
        // Die Tasten alle 10ms abfragen und Telegramm senden falls Tasten gedrückt            

        if (down_timer.GetTimerStatus(0) == 0)
        {
            down_timer.SetCountdownTimer(0,1,10);  // alle 10ms
            // Tasten abfragen
            if (S1 == 0) tasten |= 0x01; else tasten &= ~0x01;
            if (S2 == 0) tasten |= 0x02; else tasten &= ~0x02;
            if (S3 == 0) tasten |= 0x04; else tasten &= ~0x04;
            if (S4 == 0) tasten |= 0x08; else tasten &= ~0x08;
            if (S5 == 0) tasten |= 0x10; else tasten &= ~0x10;
            
            //---------------------------------------------------------------------------
            // Tastatur auswerten und Ergebnis senden
            if (tasten != tasten_old)
            {
              uart1.putc(0xE5);
              uart1.putc(0x02);
              uart1.putc(0x05);         // Telegramm für Tasten 
              uart1.putc(0x01);         // Anzahl der Nutzdaten
              uart1.putc(tasten);       // Tasteninformation
              uart1.putc(0x00);         // Abschlusszeichen
              
              tasten_old = tasten; 
              pc.printf("\nTaste %02x",tasten);
            }
        } 
        
        //--------------------------------------------------------------------------
        // Uhrzeit abfragen            
        
        if (down_timer.GetTimerStatus(2) == 0)
        {
            down_timer.SetCountdownTimer(2,2,60);    // alle 60s                                          
            
            uart1.putc(0xE5);         // Startzeichen
            uart1.putc(0x02);         // Startzeichen
            uart1.putc(0x06);         // Telegramm für Zeitabfrage 
            uart1.putc(0x00);         // Anzahl der Nutzdaten
            uart1.putc(0x00);         // Abschlusszeichen
        }
                
    } // while[1]
}