#include "mbed.h"
#include "C12832_lcd.h"

C12832_LCD lcd;
Timeout increment;
InterruptIn down(p12);
InterruptIn left (p13);
InterruptIn centre(p14);
InterruptIn up(p15);
InterruptIn right(p16);


int hours = 0;
int minutes = 0;

// switching between increasing hrs and minutes
/**
    Adjust minutes
*/

void adj_min() 
{
    if (minutes > 59) {
        minutes = 0;
    }
}

void adj_hrs()
{
    if (hours > 23) {
        hours = 0;
    }
}

/**
 Increment minutes
*/
void inc_min()
{
    minutes++;
    adj_min();
}
void inc_hrs()
{
    hours++;
    adj_hrs();
}


//function for decrementing

void dec_min()
{
    minutes--;
    adj_min();
}
void dec_hrs()
{
    hours--;
    adj_hrs();
}
void Down()
{
    if (left) {
        dec_hrs();
    } else if (right) {
        dec_min();
    }
}
void Up()
{
    if (left) {
        inc_hrs();
    } else if (right) {
        inc_min();
    }
    }


    /**
        Main entry point
    */
    int main() {

        while (1) {
            Down.rise(&Down_rise);
            Up.rise(&Up_rise);
            right.rise(&right_rise);
            left.rise(&left_rise);
            while (true) {
                increment.attach(&inc_min, 60.0);


                if (up) {
                    Up();
                }

                if (down) { //switching between decreasing minutes and hours
                    Down();
                }

                lcd.cls();
                lcd.locate(10, 10);

                // Check if minutes are less than 10 so a 0 can be prefixed onto the display
                char mins[10] = "00"; // String to display in lcd screen

                if (minutes < 10) {
                    strcpy(mins, "0" + minutes);
                } else {
                    strcpy(mins, "" + minutes);
                }
                lcd.printf("%s", mins);
                lcd.locate(20, 10);
                {
                    lcd.printf("%d", hours);
                }
            }
        }
    }