/***************************************************************************
*This is a program for an automatic pet feeder. It was designed to
*automatically dispense food at certain times of day, using a servo motor
*to  control the dispenser. However, food will  not dispense if there is
*still food left in the bowl. This condition is determined by the FSR.
*It will also not run  if the IR sensor detects that there is not enough
*food to dispense.
*The user can set the time of day  using the joystick on the mbed
*application board, which will be displayed on the LCD screen on the
*application board. The user can also set the portion size between 1 and 3
*using the LCD and joystick. The motor will move back and forth a certain
*number of times, which corresponds to the portion size.
****************************************************************************/

#include "mbed.h"
#include "Servo.h"
#include "C12832.h"
#include "IR_Dist.h"
//#include "FSR.h"

DigitalIn centre(p14); //joystick centre
DigitalIn down(p12); //joystick down
DigitalIn up(p15); //joystick up
Servo myservo(p21); //servo motor
C12832 lcd(p5, p7, p6, p8, p11); //lcd screen
AnalogIn fsr(p17); //force sensitive resistor
AnalogIn distance(p18); //ir sensor

int hours = 0;
int minutes = 0;


//myservo.calibrate(0.0005,45); //calibrating servo speed and starting position

/**
    code for  servo motor to run
*/
void servo(float fsraverage)
{
    if (fsraverage == 0) { //will only run if the fsr reading is below a certain value
            myservo.write(0.0); //position of the servo is initially at its starting poitn
            wait(1); //waits 1 second
            myservo.write(1.0); //moves the servo 90 degrees
            wait(1); //waits another second
            myservo.write(0.0); //position of the servo is initially at its starting poitn
            wait(1); //waits 1 second
    }
}


int main() {

    float iraverage; //averages ir sensor input
    float fsraverage; //averages fsr input
    while(1) {
        int set = 1;  // sets the value of the integer set to 1 initially
        lcd.cls();
        lcd.locate(0,3); //location of text on the lcd
        /**
            defines ir sensor values
        */

        iraverage = 0.0; //ir sensor average starts at 0
        for (int j=0; j<1000; j++)
            iraverage = iraverage + distance.read()/1000.0; //displays the average per 1000 readings
        wait(0.2); //waits 0.2 seconds to repeat the cycle
        /**
            defines fsr values
        */
        fsraverage = 0.0; //average of the ir sensor values is 0
        for (int k=0; k<1000; k++)
            fsraverage = fsraverage + fsr.read()/1000.0; //displays the average per 1000 readings
        wait(0.2); //waits 0.2 seconds to repeat the cycle
        /**
            condition at which the system  will not work
        */
        if (fsr == 1) {
            myservo.write(0.0);
        }
        /**
            portion size settings
        */
//        if (
        if (centre.read()) {  //if centre joystick is pressed
            lcd.printf("1");  //will print a '1' on the lcd screen
            set = 1;          //sets the value of set to 1
        }

        if (down.read()) {    //if the down joystick is pressed
            lcd.printf("2");  //prints '2' on the lcd screen
            set = 2;          //sets the value of  set to 2
        }
        if (up.read()) {      //if the up joystick is pressed
            lcd.printf("3");  //prints '3' on the lcd screen
            set = 3;          //sets the value of  set to 3
        }

    /**
        automatically dispensing food at certain times of day
    */

        if (hours == 6 || hours == 12 || hours == 18) { //if the hours is equal to either 6, 12 or 18
            for (int i = 0; i < set; i++)  //will executed the code a number of times, dependent on what the value of set is
                servo(fsraverage); //executes servo code
        }
    }
}

