#include "mbed.h"
#include "Servo.h"
#include "C12832_lcd.h"
#include "IR_Dist.h"
#include "FSR.h"

Timeout increment;
Timeout interrupt;
InterruptIn down(p12);
InterruptIn left (p13);
InterruptIn centre(p14);
InterruptIn up(p15);
InterruptIn right(p16);
Servo myservo(p21); 
C12832_LCD lcd; 
AnalogIn fsr(p17); 
AnalogIn dist(p18); 

float iraverage; //averages ir sensor input
float fsraverage; //averages fsr input

/**
    code for  servo motor to run
*/
void servo()
{
    if (fsraverage = 0) { //will only run if the fsr reading is below a certain value
        myservo = 0; //position of the servo is initially at its starting point
        wait(1); //waits 1 second
        myservo = 1; //moves the servo 90 degrees
        wait(1); //waits another second
    }
}
int hours = 0; //defines an integer value called hours and sets it to zero initially
int minutes = 0; //defines an integer value called minutes and sets it to zero initially

/**
    Adjust minutes
*/

void adj_min()
{
    if (minutes > 59) { // if the value of minutes is greater than 59
        minutes = 0; //minutes will reset to zero
    }
}

/**
    Adjust hours
*/

void adj_hrs()
{
    if (hours > 23) { //if the value of hours is greater than 23
        hours = 0; //set hours to zero
    }
}

/**
 Increment minutes
*/

void inc_min()
{
    minutes++; //increase the value of minutes by one
    adj_min(); //updates the value of adj_min
}

/**
 Increment hours
*/

void inc_hrs()
{

    hours++; //increases the value of hours by one
    adj_hrs(); //updates  the value of adj_hrs
}
/**
 Decrement minutes
*/

void dec_min()
{
    minutes--; //decrease the value of minutes by 1
    adj_min(); //updates the value of adj_min
}

/**
 Decrement hours
*/

void dec_hrs()
{
    hours--; //decreases the value of hours by 1
    adj_hrs(); //updates  the value of adj_hrs
}


void down_rise()
{
    if (left) {
        dec_hrs();
    } else if (right) {
        dec_min();
    }
}
void up_rise()
{
    if (left) {
        inc_hrs();
    } else if (right) {
        inc_min();
    }
}

int main()
{
    down.rise(&down_rise);
    up.rise(&up_rise);
    int set = 1;  // sets the value of the integer set to 1 initially
    myservo.calibrate(0.0005,45); //calibrating the float degrees and float position
    while(1) {
        increment.attach(&inc_min, 60.0);
        lcd.cls();
        lcd.locate(0,3); //location of text on the lcd
        /**
            defines ir sensor values
        */
        iraverage = 0.0; //ir sensor average starts at 0
        for (int j=0; j<1000; j++) {
            iraverage = iraverage + dist.read()/1000.0; //displays the average per 1000 readings
            wait(0.2); //waits 0.2 seconds to repeat the cycle
        }
        /**
            defines fsr values
        */
        fsraverage = 0.0; //average of the ir sensor values is 0
        for (int k=0; k<1000; k++) {
            fsraverage = fsraverage + fsr.read()/1000.0; //displays the average per 1000 readings
            wait(0.2); //waits 0.2 seconds to repeat the cycle
        }
        /**
            condition at which the system  will not work
        */
        if ((iraverage = 0) || (fsraverage = 0)) {
            myservo = 0;

            if (centre) {
                if (up) {
                    if (up) { //switching between increasing minutes and hours
                        up_rise();
                    }

                    if (down) { //switching between decreasing minutes and hours
                        down_rise();
                    }

                    lcd.cls();
                    lcd.locate(10, 10);

                    // Check if minutes are less than 10 so a 0 can be prefixed onto the display
                    char mins[10] = "00"; // String to display in lcd screen

                    if (minutes < 10) {
                        strcpy(mins, "0" + minutes);
                    } else {
                        strcpy(mins, "" + minutes);
                    }
                    lcd.printf("%s", mins);
                    lcd.locate(20, 10);
                    {
                        lcd.printf("%d", hours);
                    }
                }
                /**
                    portion size settings
                */
                if (down)
                    if (centre) { //if centre joystick is pressed
                        lcd.printf("1");  //will print a '1' on the lcd screen
                        set = 1; //sets the value of set to 1
                    }
                if (down) { //if the down joystick is pressed
                    lcd.printf("2"); //prints '2' on the lcd screen
                    set = 2; //sets the value of  set to 2
                }
                if (up) { //if the up joystick is pressed
                    lcd.printf("3"); //prints '3' on the lcd screen
                    set = 3; //sets the value of  set to 3
                }
            }
        }
        /**
            automatically dispensing food at certain times of day
        */
        if ((hours = 6) || (hours = 12) || (hours = 18)) { //if the hours is equal to either 6, 12 or 18
            int i;
            for (i = set; i = i + 1;) { //will executed the code a number of times, dependent on what the value of set is
                servo(); //executes servo code
            }
        }
    }
}