/* File: IR_Dist.h
 * Author: Geert Huisman  
 * Board: STM NUCLEO F401RE, 
 * Hardware: IR Range GP20A41SK,  
 *
 * Desc: driver for GP20A41SK IR Distance sensor.  The returned range
 * is in units of cm meters.
 *  
 *       
 *
*/

/* EXAMPLE
#include "mbed.h"
#include "IR_Dist.h"

//A0 Analoogin
   IR_Dist IRSense(A0); 
int main() {
    while(1) {
        
     float distance = IRSense.distance();   
      printf("distance %2.0f   \n",distance);
      wait(1.0);  
        
    }
}
*/

#ifndef IR_Dist_H
#define IR_Dist_H
#include "mbed.h"
 
class IR_Dist {
  public:
    IR_Dist(PinName a);
    float Equation();
    float distance();
     
    private:
        AnalogIn IRSens;
        int16_t volts;
        float som, correction, distance_cm;
};
 
#endif