/**************************************************************
/ ME21001  Group 2-8
/
/ Lab 04   Exercise 5
/
/ This program reads an analogue input and displays the results
/ to the PC
/
/**************************************************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);   // USB serial interface
AnalogIn A_in(p17);        // analogue input pin for reference values
DigitalIn switchstate(p18);

int main() {

  float analogue_val=0.0;  // variable to hold the analogue input values as decimals
  int integer_val=0; //  variable to hold the analogue input values as integers
  float int_valcon=0;
  
  // set the USB serial interface baud rate
  pc.baud(921600);

 while(1) {                // repeat indefinitely
    
    // read the voltage on the analogue input pin and convert it to a
    // decimal number with 12-bit resolution
    analogue_val = A_in.read();
    integer_val=A_in.read_u16();
    int_valcon=((float)integer_val/65535)*3.3;
    
    // export the readings to a terminal program via the USB cable
    pc.printf("Analogue value: %6.4f     integer value: %i  Equivalent voltage to analogue: %6.4f Equivalent voltage to integer: %6.4fvdc\n\r", analogue_val,integer_val,analogue_val*3.3,int_valcon);

    wait(0.250);           // wait 250ms
  }
}

