#include "mbed.h"

Serial pc(USBTX, USBRX);                     // USB Serial interface
AnalogIn A_in(p17);                          // set p17 for analogue input
DigitalOut myled1(LED1);                     // Use onboard LED1
DigitalOut myled2(LED2);                     // Use onboard LED2
DigitalOut myled3(LED3);                     // Use onboard LED3
DigitalOut myled4(LED4);                     // Use onboard LED4

int main() { 
    
    float analogue_val=0.0;                  // variable to hold analogue input
    
    while(1) {                               // repeat indefinetly
    
        analogue_val = A_in.read();          // convert voltage to analogue input
        
        if(analogue_val < 0.2)  {            // if input value less then 0.2 turn off all LEDs
            myled1 = 0; 
            myled2 = 0;
            myled3 = 0;
            myled4 = 0;
            }
            
        else if(analogue_val < 0.4)   {      // if input value less then 0.4 turn on LED 1 and turn off LEDs 2, 3 and 4
            myled1 = 1;
            myled2 = 0;
            myled3 = 0;
            myled4 = 0;
            }
            
        else  if(analogue_val < 0.6)  {      // if input value less then 0.4 turn on LEDs 1 and 2 and turn off LEDs 3 and 4
            myled1 = 1;
            myled2 = 1;
            myled3 = 0;
            myled4 = 0;
            }
        else  if(analogue_val < 0.8)  {      // if input value less then 0.8 turn on LEDs 1, 2 and 3 and turn off LED 4
            myled1 = 1;
            myled2 = 1;
            myled3 = 1;
            myled4 = 0;
            }
            
        else {                               // if input value greater then 0.8 turn on all LEDs
            myled1 = 1;
            myled2 = 1;
            myled3 = 1;
            myled4 = 1;
            }
    
    }
        
}            