/**************************************************************
/ ME21001  Group m-nn
/
/ Lab 04   Exercise 4
/
/ This program reads an analogue input and displays the results
/ to the PC
/
/**************************************************************/

#include "mbed.h"

Serial pc(USBTX, USBRX);   // USB serial interface
AnalogIn A_in(p17);        // analogue input pin for reference values

int main() {

  float analogue_val=0.0;  // variable to hold the analogue input values as decimals
  
  // set the USB serial interface baud rate
  pc.baud(921600);

 while(1) {                // repeat indefinitely
    
    // read the voltage on the analogue input pin and convert it to a
    // decimal number with 12-bit resolution
    analogue_val = A_in.read();
    
    // export the readings to a terminal program via the USB cable
    pc.printf("Analogue value: %6.4f     Equivalent voltage: %6.4fvdc\n\r", analogue_val,analogue_val*3.3);

    wait(0.250);           // wait 250ms
  }
}
