#include "mbed.h"
 
 
#define MAX_LEN 64
//tester
//DigitalOut led1(LED1);
//InterruptIn button(p28);
 
//Timer class
Timer timer_tf;
 
//print for debug
Serial pc(USBTX, USBRX);
 
// Digital outputs
DigitalOut led1(LED1);  // digital out LED 1
DigitalOut led2(LED2);  // Digital out LED 2
DigitalOut led3(LED3);  // Digital out LED 3
 
//interrupt  only on p15,16,17,18
InterruptIn button1(p15);   //interrupt button Pin 15
InterruptIn button2(p16);   //interuppt button Pin 16
InterruptIn button3(p17);   //interuppt button Pin 17
InterruptIn button4(p18);   //interuppt button Pin 18
 
//Traffic light 1+2 pin allocation for lights
DigitalOut t1red(p23);
DigitalOut t1yellow(p24);
DigitalOut t1green(p25);
 
//Traffic lights 2+4 Pin allocation for lights
DigitalOut t2red(p12);
DigitalOut t2yellow(p13);
DigitalOut t2green(p14);
 
//switch
//DigitalIn button1(p26);
//DigitalIn button2(p27);
//DigitalIn button3(p28);
 
 
 
 
 
void t1light(char a)        //set up for first pair of lights
{
    //**********Could this be removed**************
    t1red = 0;              //red is off
    t1yellow = 0;           //yelow is off
    t1green = 0;            //green is off
    if (a == 'R') {         //setting for red light.
        t1red = 1;          //red is on
        t1yellow = 0;       //yellow is off
        t1green = 0;        //green is off
    } else if(a == 'F') {   //setting for red and yellow lights
        t1red = 1;          //red is on
        t1yellow = 1;       //yellow is on  
        t1green = 0;        //green is off
    } else if(a == 'Y') {   //settings for yellow light
        t1red = 0;          //red is off
        t1yellow = 1;       //yellow is on
        t1green = 0;        //green is off
    } else if(a == 'G') {   //setting for green light
        t1red = 0;          //red is off
        t1yellow = 0;       //yellow is off
        t1green = 1;        //green is on
        //**********Could this be removed**************
    } else {                //if none selected     
        t1red = 0;          //red is off
        t1yellow = 0;       //yellow is off
        t1green = 0;        // green is off
    }
}
 
void t2light(char a)        //set up for second pair of lights
{
    //**********Could this be removed**************
    t2red = 0;              //red is off
    t2yellow = 0;           //yellow is off
    t2green = 0;            //green is off
    if (a == 'R') {         //setting for red light
        t2red = 1;          //red is on
        t2yellow = 0;       //yellow is off
        t2green = 0;        //green is off
    } else if(a == 'F') {   //setting for red and yellow lights
        t2red = 1;          //red is on    
        t2yellow = 1;       //yellow is on
        t2green = 0;        //green is off
    } else if(a == 'Y') {   //setting for yellow light
        t2red = 0;          //red is off
        t2yellow = 1;       //yellow is on
        t2green = 0;        //green is off
    } else if(a == 'G') {   //setting for green light 
        t2red = 0;          //red is off
        t2yellow = 0;       //yellow is off
        t2green = 1;        //green is on
      //**********Could this be removed**************
    } else {                //if none is selected
        t2red = 0;          //red is off
        t2yellow = 0;       // yellow is off
        t2green = 0;        //green is off
    }
}
 
 
 
void traffic (char t1, char t2, int time_end)
{
    if(timer_tf.read() <= time_end) {
        t1light(t1);
        t2light(t2);
        timer_tf.reset();
    }
    //wait(time);
    }
 
void traffic_timer (char t1, char t2){
    t1light(t1);
    t2light(t2);
    }
 
void traffic_default (char t1, char t2, int time){
    t1light(t1);
    t2light(t2);
    wait(time);
    }
 
 
 
void normal_traffic(){
///*
    if(timer_tf.read() >= 0 && timer_tf.read() <=4) { // From 0 to 10 seconds T1 is green T2 is red
        traffic_timer('G','R');
    }
    if(timer_tf.read() >= 5 && timer_tf.read() <= 6) { // From 11 to 16 seconds T1 is Yellow T2 is red
        traffic_timer('Y','R');
    }
    if(timer_tf.read() >= 7 && timer_tf.read() <= 8) { // From 17 to 23 seconds T1 is Red T2 is Red and yellow
        traffic_timer('R','F');
    }
    if(timer_tf.read() >= 9 && timer_tf.read() <= 13) { // From 24 to 30 seconds T1 is Red T2 is green
        traffic_timer('R','G');
    }
    if(timer_tf.read() >= 14 && timer_tf.read() <= 15) { // From 31 to 37 seconds T1 is red T2 is yellow
        traffic_timer('R','Y');
    }
     if(timer_tf.read() >= 16 && timer_tf.read() <= 17) { // From 38 to 44 seconds T1 is red and yellow and T2 is red
        traffic_timer('F','R');
        }
    if(timer_tf.read() >= 18 && timer_tf.read() <= 22) { // From 45 to 51 seconds T1 is Green T2 is red
        traffic_timer('G','R');
        }   
    if(timer_tf.read() >= 23 && timer_tf.read() <= 24) { // From 45 to 51 seconds T1 is yellow T2 is red
        traffic_timer('Y','R');
        }   
    if(timer_tf.read() >= 25 && timer_tf.read() <= 26) { // From 45 to 51 seconds T1 is red T2 is red and yellow 
        traffic_timer('R','F');
        }   
    if(timer_tf.read() >= 27 && timer_tf.read() <= 31) { // From 45 to 51 seconds T1 is red T2 is green 
        traffic_timer('R','G');
        }  
    if(timer_tf.read() >= 32 && timer_tf.read() <= 33) { // From 45 to 51 seconds T1 is red T2 is yellow
        traffic_timer('R','Y');
        }    
    if(timer_tf.read() >= 34 && timer_tf.read() <= 35) { // From 45 to 51 seconds T1 is red and yellow T2 is red
        traffic_timer('F','R');
        }   
    if(timer_tf.read() >= 36){     // reset timer at 52
        timer_tf.reset();
    }
    // timings for above when not testing
    //traffic_default('G','R',40);
    //traffic_default('Y','R',10);
    //traffic_default('R','F',10);
    //traffic_default('R','G',40);
    //traffic_default('R','Y',10);
    //traffic_default('F','R',10);
}
 
void flip1(){
    led1 = !led1;       // led one to activate when buton for crossing is pushed
    timer_tf.stop();
    //pc.printf("%f\n",timer_tf.read());
    //wait(10);
    //pc.printf("%f\n",timer_tf.read());
    //imer_tf.start();
    //wait(5);
    //pc.printf("%f\n",timer_tf.read());
    /*
        if(timer_tf.read() <= 47){
        wait(15);
        }
    */
    if(timer_tf.read() >= 0/*48*/ && timer_tf.read() <= 10) {
        wait(15);
    }
    if(timer_tf.read() >= 16 && timer_tf.read() <= 23) {
        //traffic_timer('R','G');
        traffic_default('R','Y',3);
        traffic_default('G','R',15);
        traffic_default('Y','R',3);
    }
    if(timer_tf.read() >= 24 && timer_tf.read() <= 30) {
        //traffic_timer('R','Y','R');
        wait(3);
        traffic_default('G','R',15);
        traffic_default('Y','R',3);
    }
 
    timer_tf.start();
    led1 = !led1;
}
 
void flip2(){
    led2 = !led2;
    timer_tf.stop();
    if(timer_tf.read() >= 0 && timer_tf.read() <= 10) {
        //traffic_timer('G','R',);
        traffic_default('Y','R',3);
        traffic_default('R','G',15);
        traffic_default('R','Y',3);
    }
    if(timer_tf.read() >= 16 && timer_tf.read() <= 23) {
        //traffic_timer('Y','R','R');
        wait(3);
        traffic_default('R','G',15);
        traffic_default('R','Y',3);
    }
    /*
        if(timer_tf.read() >= 52 && timer_tf.read() <= 90){
        //traffic_timer('R','G','R');
        wait(15);
        }
    */
    if(timer_tf.read() >= 24/*91*/ && timer_tf.read() <= 30) {
        //traffic_timer('R','Y');
        wait(15);
    }
    timer_tf.start();
    led2 = !led2;
}
 
 
int main(){
 
    timer_tf.start();
 /*   
        if(button1 == 1){
        flip1();
        }else if(button2 == 1){
        flip2();
        }else{}
   */ 
    button1.mode(PullUp);
    button1.fall(&flip1);
    button2.mode(PullUp);
    button2.fall(&flip2);
    button3.mode(PullUp);
    button3.fall(&flip1);
    button4.mode(PullUp);
    button4.fall(&flip2);
    while(1) {
        normal_traffic();
 
    }
}
 
//*****************************END OF PROGRAMME******************************