#include "mbed.h"
#define WAIT_FOR_ISR    1
//Function declarations
void Function1();
void ISR();

//Thread
Thread t1;

//I/O
DigitalOut led1(LED1);
DigitalOut led2(LED2);
InterruptIn  onBoardSwitch(USER_BUTTON);

//Switch ISR
void ISR() {
    t1.signal_set(WAIT_FOR_ISR);
}

//Thread
void Function1() {
    while (true) {
        Thread::signal_wait(WAIT_FOR_ISR);
        wait(0.2); //Debounce
        Thread::signal_clr(WAIT_FOR_ISR);
        led1 = !led1;
    }
}

//Main thread
int main() {
    //Initial state
    led1 = 1;
    led2 = 1;   
    onBoardSwitch.rise(ISR);
    
    //Create and run threads (C function pointers)
    t1.start(Function1);           
        
    //Main thread loop
    while(1) {
        led2 = !led2;
        Thread::wait(100);
    }
}
