/* Access an SD Card using SPI */
 
 #include "mbed.h"
 #include "SDBlockDevice.h"
 #include "FATFileSystem.h"
 #include "sample_hardware.hpp"
 #include "mbed_events.h"
 
 //SD Card Object
SDBlockDevice sd(PB_5, D12, D13, D10); // mosi, miso, sclk, cs

//Event queue for main
EventQueue queue;

//File pointer for the SD card
FILE* fp;

//Flag to indicate if the user has ejected the SD card
bool ejected = false;

//This is called every 5 seconds by the main event queue (main thread) 
void takeSample()
{
    //If the card is unmounted, just return
    if (ejected == true) {
        return;    
    }
    
    //Read Sensors (I2C)
    float temp     = sensor.getTemperature();
    float pressure = sensor.getPressure();
    
    //Write to SD Card
    fprintf(fp, "%f,%f\n", temp, pressure);
    
    //Flash to indicate the sampling is alive
    redLED = 1;
    Thread::wait(100);
    redLED = 0;
    
    //Chheck switches - press both to eject
    if ((SW1 == 1) && (SW2 == 1)) {
        //Close File
        fclose(fp);
        
        //Close down SD card (flush buffers)
        sd.deinit();
        
        //Let user know     
        puts("You can now remove the SD Card\n");
        yellowLED = 1;
        
        //Flag to record the event
        ejected = true;
    }
}
 
 int main()
{
    //POWER ON SELF TEST
    post();
    
    printf("Initialise\n");
    //FileSystemLike(*sd);

    // call the SDBlockDevice instance initialisation method.
    if ( sd.init() != 0) {
        printf("Init failed \n");
        errorCode(FATAL);
    }    
    
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);
    
    // **************
    // Open to APPEND
    // **************
    fp = fopen("/sd/test.txt","a");
    
    //Check file handle (stream)
    if (fp == NULL) {
        error("Could not open file for write\n");
        errorCode(FATAL);
    }
    
    //Set up tasks on the main thread
    queue.call_every(5000, takeSample);
    
    //Main queue event loop
    queue.dispatch();

}
