/* Access an SD Card using SPI */
 
 #include "mbed.h"
 #include "SDBlockDevice.h"
 #include "FATFileSystem.h"
 #include "sample_hardware.hpp"
 
 //SD Card Object
 SDBlockDevice sd(PB_5, D12, D13, D10); // mosi, miso, sclk, cs

 uint8_t block[512] = "Hello World!\n";
 int main()
{
    //POWER ON SELF TEST
    post();
    
    printf("Initialise\n");
    //FileSystemLike(*sd);

    // call the SDBlockDevice instance initialisation method.
    if ( sd.init() != 0) {
        printf("Init failed \n");
        errorCode(FATAL);
    }    
    
    //Create a filing system for SD Card
    FATFileSystem fs("sd", &sd);
    
    // *************
    // Open to WRITE
    // *************
    printf("Write to a file\n");
    FILE* fp = fopen("/sd/test.txt","a");
    //Check file handle (stream)
    if (fp == NULL) {
        error("Could not open file for write\n");
        errorCode(FATAL);
    }
    
    //Put some text in the file...
    fprintf(fp, "Welcome to ELEC350\n");
    
    //Close the file
    fclose(fp);
    
    // ************
    // Open to READ
    // ************
    printf("Read a file\n");
    fp = fopen("/sd/test.txt","r");
    if (fp == NULL) {
        error("Could not open file for read\n");
        errorCode(FATAL);
    }   
    
    //Read back all strings
    char s1[64];
    while (fscanf(fp, "%s", s1) == 1) {
        printf("READ BACK: %s\n", s1);
    }
    //To read a whole line, use: fgets(s1, sizeof(s1), fp);
    
    
    //Close File
    fclose(fp);
    
    //Close down
    sd.deinit();
    printf("All done...\n");
    errorCode(OK);
    
    //Flash to indicate goodness
    while(true) {
        greenLED = 1;
        wait(0.5);
        greenLED = 0;
        wait(0.1);    
    }
}
