#include "mbed.h"
#include <iostream>
#include "sample_hardware.hpp"
#include "mbed_events.h"
void do_rising();
void enableRising();
 
DigitalOut led(LED1);
InterruptIn btn(USER_BUTTON);

class ButtonManager {
    private:
    InterruptIn& input;
    EventQueue&  q;
    unsigned int count;      
    unsigned int state;

    void risingEdgeISR() {
        if (state == 0) {
            input.rise(NULL);
            led = !led;
            state = 1;
            q.call_in(200, callback(this, &ButtonManager::risingEdgeHasSettled));
            q.call(printf, "Pressed %d times\n", ++count);
        }
    }    
    
    void risingEdgeHasSettled() {
        state = 2;
        input.fall(callback(this, &ButtonManager::fallingEdgeISR));
        printf("Rising edge has settled\n");
    }   
    
    void fallingEdgeISR() {
        if (state == 2) {
            input.fall(NULL);
            state = 3;
            q.call_in(200, callback(this, &ButtonManager::fallingEdgeHasSettled));
            q.call(printf, "Falling edge detected\n");
        }
    }
    
    void fallingEdgeHasSettled() {
        state = 0;
        input.rise(callback(this, &ButtonManager::risingEdgeISR));
        printf("Falling edge has settled\n");
    }  
     
    public:
    
    ButtonManager(InterruptIn& ip, EventQueue& queue) : input(ip), q(queue) { 
        count=0;
        state=0;
        input.rise(callback(this, &ButtonManager::risingEdgeISR));
        printf("Initialised\n");   
    }
    
};

    
int main() {
    //Creates a queue with the default size
    EventQueue queue;
    
    //Map button state machine onto the main queue
    ButtonManager bm(btn, queue);

    // events are executed by the dispatch method
    queue.dispatch();
    
    //Unreachable code
    printf("This should never appear!\n");
}


