#include "mbed.h"
#include <iostream>
#include "sample_hardware.hpp"
#include "mbed_events.h"
void do_rising();
void enableRising();
 
DigitalOut led(LED1);
InterruptIn btn(USER_BUTTON);

// creates a queue with the default size
EventQueue queue;
unsigned int buttonCount = 0;

    
int main() {
    
    //Hook up isr
    enableRising();

    // events are simple callbacks
    queue.call(printf, "called immediately on dispatch\n");
    queue.call_in(2000, printf, "called after 2 seconds\n");
    queue.call_every(1000, printf, "called every 1 seconds\n");

    // events are executed by the dispatch method
    queue.dispatch();
    
    //Unreachable code
    printf("This should never appear!\n");
}

//ISR
void do_rising() {
    //ISR response time (fast)
    led = !led;
    
    //Turn off this interrupt (fast)
    btn.rise(NULL);

    //Post the following into the main thread event queue

    //Turn back on after a delay
    queue.call_in(1000, enableRising);  
    
    //Dispatch to the main thread queue
    queue.call(printf, "Button depressed %5d times\n", ++buttonCount);
}

//Enable the rising edge
void enableRising() {
    btn.rise(do_rising);    
}
