#include "mbed.h"
#include <iostream>
#include "sample_hardware.hpp"

#include "string.h"
#include <stdio.h>
#include <ctype.h>

#define SWITCH1_RELEASE 1

void thread1();
void thread2();
void switchISR();

InterruptIn  sw(PE_12);

//Threads
Thread t1(osPriorityRealtime);  //Higher priority
Thread t2(osPriorityNormal);


//Called on the falling edge of a switch
void switchISR() {
     t1.signal_set(SWITCH1_RELEASE);    //Very short
}

//High priority thread
void thread1() 
{
    redLED = 1;
    while (true) {
         //Block (WAITING) for signal from the ISR
         Thread::signal_wait(SWITCH1_RELEASE);
         
         //Flash LED
         redLED = !redLED;
         
         //Wait for switch bounce to settle
         Thread::wait(200); 
         
         //Block using BUSY-WAIT
//         Timer t;
//         t.start();
//         while (t < 2);
         
         //Clear any additional signals (caused by switch bounce and ISR)
         t1.signal_clr(SWITCH1_RELEASE);   //Debounce - clear pending signals
    }
}

//This thread has normal priority
void thread2() 
{
    greenLED = 1; 
    while (true) {   
        Thread::wait(500);          // WAIT FOR 0.5 SECONDS - spinning
        greenLED = !greenLED;
    }
}


// Main thread
int main() {
        
    //Power on self-test       
    post();
    
    //Start Threads
    t1.start(thread1);
    t2.start(thread2);
    
    //Hook up interrupt
    sw.fall(switchISR);      
        
    printf("Main Thread\n");
    while (true) {
        Thread::wait(osWaitForever);
    }

}

   
