#include "mbed.h"

#include "string.h"
#include <stdio.h>
#include <ctype.h>
#include "sample_hardware.hpp"

#define DELAY 200


//Thread ID for the Main function (CMSIS API)
osThreadId tidMain;

void thread1() 
{
    printf("Entering thread 1\n");
    while (true) {
        yellowLED = 1;
        Thread::wait(DELAY);   
        yellowLED = 0;
        Thread::wait(DELAY);               
    }
}

//This thread has higher priority
void thread2() 
{
    printf("Entering thread 2\n");  
    while (true) {
        redLED = 1;
        if (SW1 == 1) {
            
            // 1) Select the 'type' of wait
            
            //wait_ms(osWaitForever);
            Thread::wait(osWaitForever); 
        } else {
            Thread::wait(DELAY);    
        }
        redLED = 0;
        Thread::wait(DELAY);               
    }
}


//Main thread
int main() {
    post();
                    
    //Main thread ID
    tidMain = Thread::gettid();  
    
    //Create a thread with normal priority
    Thread t1(osPriorityNormal);
    t1.start(thread1);
    
    // 2) Select the Thread Priority
    
    //Thread t2(thread2, NULL, osPriorityNormal);
    Thread t2(osPriorityAboveNormal);
    t2.start(thread2);
    
    printf("Main Thread\n");
    while (true) {
        Thread::wait(osWaitForever);
    }

}

   
