#include "morse_generator.hpp"
#include "sample_buffer.hpp"
#include "sample_hardware.hpp"

//Delays in ms
#define TUNIT 250
#define TDOT  TUNIT
#define TDASH (3*TUNIT)
#define TGAP TUNIT
#define TLETTER (3*TUNIT)
#define TWORD (7*TUNIT)

/* 
**** Morse Code ***

.               1 unit
-               3 units
inter-space     1 unit

between letters 3 units
between words   7 units
*/

//Morse code
const char* const morseAlpha[] = {
    ".-",   //A
    "-...", //B
    "-.-.", //C
    "-..",  //D
    ".",    //E
    "..-.", //F
    "--.",  //G
    "....", //H
    "..",   //I
    ".---", //J
    "-.-",  //K
    ".-..", //L
    "--",   //M
    "-.",   //N
    "---",  //O
    ".--.", //P
    "--.-", //Q
    ".-.",  //R
    "...",  //S
    "-",    //T
    "..-",  //U
    "...-", //V
    ".--",  //W
    "-..-", //X
    "-.--", //Y
    "--.."  //Z
};

const char* const morseNumeric[] = {
    "-----",    //0
    ".----",    //1
    "..---",    //2
    "...--",    //3
    "....-",    //4
    ".....",    //5
    "-....",    //6
    "--...",    //7
    "---..",    //8
    "----."     //9    
};

void morseGenerator() 
{
    while (true) {
        
        //Are there samples available?
        char nextChar = takeCharacterFromQueue();  
        nextChar = tolower(nextChar);
        
        //Look up morse code
        
        //Space between words - assumes only one
        if (nextChar == ' ') {
            Thread::wait(TWORD-TLETTER);
            continue;   
        }
        
        //Number?
        const char *nextString;
        if ((nextChar >= '0') && (nextChar <= '9')) {
            nextString = morseNumeric[nextChar - '0'];   
        }
        //Character?
        else if ((nextChar >='a') && (nextChar <= 'z')) {
            nextString = morseAlpha[nextChar - 'a'];   
        } else {
            //Invalid
            continue;   
        }
        
        //Flash morse for this letter
        for (unsigned int n=0; n<strlen(nextString); n++) {
            char symb = nextString[n];
            greenLED = 1;
            switch (symb) {
                case '.':
                    Thread::wait(TDOT);
                    break;
                case '-':
                    Thread::wait(TDASH);
                    break;
                default:
                    break;  
            }
            greenLED = 0;
            
            //A gap between symbols
            Thread::wait(TGAP);    
        } 
        
        //Gap between letters
        Thread::wait(TLETTER-TGAP);
        
    }      
}