#include "mbed.h"
#include "sample_buffer.hpp"
#include "morse_generator.hpp"
#include "sample_hardware.hpp"

//Thread ID for the Main function (CMSIS API)
osThreadId tidMain;


//Main thread
int main() {
    Thread writer;
    
    //Power On Test - check PuTTY and the LEDs
    pot();
      
    //Main thread ID
    tidMain = Thread::gettid();  
    
    //Thread for outputting mors
    writer.start(morseGenerator);
    
    printf("Type characters to send\n");
    while (true) {
        //Read keyboard (serial port)
        char c = getchar();
        addCharacterToQueue(c);
    }

}



   
