#include "mbed.h"

#define RED_DONE 1
#define YELLOW_DONE 2


//Function declarations
void countUP();
void countDOWN();

DigitalOut onBoardLED(LED1);
DigitalOut redLED(PE_15);
DigitalOut yellowLED(PB_10);
DigitalOut greenLED(PB_11);

DigitalIn  onBoardSwitch(USER_BUTTON);
DigitalIn  SW1(PE_12);
DigitalIn  SW2(PE_14);

//Thread ID for the Main function (CMSIS API)
osThreadId tidMain;

//Stared mutable state
volatile long long count = 0;

//Threads
void countUP()
{
    redLED = 1;
    
    for (unsigned int n=0; n<1000000; n++) {
        count++;
        count++;        
        count++;
        count++;    
        count++;
        count++; 
        count++;
        count++;
        count++;
        count++;   
    }
    
    redLED = 0;
    osSignalSet(tidMain, RED_DONE);  //Signal main thread we are done
}

void countDOWN()
{
    yellowLED = 1;
    
    for (unsigned int n=0; n<1000000; n++) {
        count--;
        count--;        
        count--;
        count--;    
        count--;
        count--; 
        count--;
        count--;
        count--;
        count--;               
    }   
    
    osSignalSet(tidMain, YELLOW_DONE); //Signal main thread we are done
    yellowLED = 0;
}


//Main thread
int main() {
    Thread t1, t2;
    
    redLED    = 0;
    yellowLED = 0;
    greenLED  = 1;
    
    //Main thread ID
    tidMain = Thread::gettid();  
    
    //Press the switch to run concurrently
    if (onBoardSwitch == 1) {
        printf("Running sequntially\n");
        countUP();
        countDOWN();        
    } else {
        printf("Running concurrently\n");
        t1.start(countUP);           
        t2.start(countDOWN);    
  
        //Wait for the ALL_ON signal
        Thread::signal_wait(RED_DONE,osWaitForever);
        Thread::signal_wait(YELLOW_DONE,osWaitForever);        
    }

    printf("Final result = %lld\n", count);
    if (count == 0) {
        greenLED = 0;
    }
    while(true);
}
